/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.AsciiColorPalette;

public class MessageTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testErrorMessage1() {
        String[] theArgs = new String[]{"--string=someString", "--token=1234567890"};
        String theExpected = "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, though it must be specified to match the according syntax branch! Noteworthy in this context: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!";
        String theHeurisiticExprected = "Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, though it must be specified to match the according syntax branch! Noteworthy in this context: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!";
        ArgsParser theParser = MessageTest.createArgsParser();
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String theMessage = e.toMessage();
            String theHeuristicMessage = e.toHeuristicMessage();
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("toMessage() = " + theMessage);
                System.out.println("toHeuristicMessage() = " + theHeuristicMessage);
            }
            Assertions.assertEquals((Object)theExpected, (Object)theMessage);
            Assertions.assertEquals((Object)theHeurisiticExprected, (Object)theHeuristicMessage);
        }
    }

    @Test
    public void testErrorMessage2() {
        String[] theArgs = new String[]{"--string=someString", "--email=someEmail", "--token=1234567890"};
        String theExpected = "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!";
        String theHeurisiticExprected = "Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, though it must be specified to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\"  was found in the command line arguments, at least one of them must be specified to match the according syntax branch!";
        ArgsParser theParser = MessageTest.createArgsParser();
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String theMessage = e.toMessage();
            String theHeuristicMessage = e.toHeuristicMessage();
            if (IS_LOG_TEST_ENABLED) {
                System.out.println("toMessage() = " + theMessage);
                System.out.println("toHeuristicMessage() = " + theHeuristicMessage);
            }
            Assertions.assertEquals((Object)theExpected, (Object)theMessage);
            Assertions.assertEquals((Object)theHeurisiticExprected, (Object)theHeuristicMessage);
        }
    }

    private static ArgsParser createArgsParser() {
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theString1Arg, CliSugar.optional((Term[])new Term[]{theString2Arg, CliSugar.xor((Term[])new Term[]{theboolArg, theBoolFlag, CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg})}), theIntArg, theDoubleArg})}), theHelpFlag, theVersionFlag});
        return theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }
}

