/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.solidcoding.validation.api.ContinuingValidator;
import org.solidcoding.validation.api.EndingValidator;
import org.solidcoding.validation.api.ReturningValidator;
import org.solidcoding.validation.api.Rule;

final class ContinuingPredicateValidator<T>
implements ContinuingValidator<T> {
    private final List<Rule<T>> ruleDefinitions;
    private final T value;
    private String message;

    ContinuingPredicateValidator(List<Rule<T>> ruleDefinitions, T value) {
        this.ruleDefinitions = ruleDefinitions;
        this.value = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ContinuingValidator<T> and(Rule<T> rule) {
        this.ruleDefinitions.add(rule);
        return this;
    }

    @Override
    public boolean validate() {
        this.message = "Nothing to report";
        StringBuilder stringBuilder = new StringBuilder();
        boolean isValid = true;
        for (Rule<T> ruleDefinition : this.ruleDefinitions) {
            if (ruleDefinition.test(this.value)) continue;
            stringBuilder.append("Rule broken: ").append(ruleDefinition.getFailMessage()).append("\n");
            isValid = false;
        }
        if (!isValid) {
            this.message = stringBuilder.toString();
        }
        return isValid;
    }

    @Override
    public <R> ReturningValidator<R> andThen(Supplier<R> supplier) {
        return new EndingValidator(supplier, this);
    }

    @Override
    public <E extends RuntimeException> boolean orElseThrow(Function<String, E> throwableFunction) {
        boolean isValid = this.validate();
        if (!isValid) {
            throw (RuntimeException)throwableFunction.apply(this.getMessage());
        }
        return true;
    }

    @Override
    public T orElseReturn(T other) {
        boolean isValid = this.validate();
        if (!isValid) {
            return other;
        }
        return this.value;
    }

    @Override
    public T orElseReturn(Function<String, T> other) {
        boolean isValid = this.validate();
        String message = this.message;
        if (!isValid) {
            return other.apply(message);
        }
        return this.value;
    }
}

