/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.function.Function;
import java.util.function.Supplier;
import org.solidcoding.validation.api.ContinuingValidator;
import org.solidcoding.validation.api.ReturningValidator;

final class EndingValidator<T, R>
implements ReturningValidator<R> {
    private final Supplier<R> supplier;
    private final ContinuingValidator<T> businessRuleValidator;

    EndingValidator(Supplier<R> supplier, ContinuingValidator<T> businessRuleValidator) {
        this.supplier = supplier;
        this.businessRuleValidator = businessRuleValidator;
    }

    @Override
    public <E extends RuntimeException> R orElseThrow(E throwable) {
        boolean isValid = this.businessRuleValidator.validate();
        if (!isValid) {
            throw throwable;
        }
        return this.supplier.get();
    }

    @Override
    public R orElseReturn(R other) {
        boolean isValid = this.businessRuleValidator.validate();
        if (!isValid) {
            return other;
        }
        return this.supplier.get();
    }

    @Override
    public R orElseReturn(Function<String, R> other) {
        boolean isValid = this.businessRuleValidator.validate();
        String message = this.businessRuleValidator.getMessage();
        if (!isValid) {
            return other.apply(message);
        }
        return this.supplier.get();
    }
}

