/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.solidcoding.validation.predicates.DecimalNumberConstraintPredicate;

public final class DecimalNumberPredicate
implements Predicate<Double> {
    private final List<Predicate<Double>> rules = new ArrayList<Predicate<Double>>();

    private DecimalNumberPredicate() {
    }

    private DecimalNumberPredicate(Predicate<Double> rule) {
        this.rules.add(rule);
    }

    public static DecimalNumberPredicate beADecimalNumber() {
        return new DecimalNumberPredicate();
    }

    public static DecimalNumberPredicate beADecimalNumber(double value) {
        return new DecimalNumberPredicate(x -> x == value);
    }

    public static DecimalNumberPredicate beADecimalNumber(Predicate<Double> rule) {
        return new DecimalNumberPredicate(rule);
    }

    public DecimalNumberConstraintPredicate between(double first) {
        return new DecimalNumberConstraintPredicate(first, this);
    }

    public DecimalNumberPredicate containing(int number, int ... numbers) {
        this.rules.add(x -> String.valueOf(x).contains(String.valueOf(number)));
        for (int i : numbers) {
            this.rules.add(x -> String.valueOf(x).contains(String.valueOf(i)));
        }
        return this;
    }

    public void addPredicate(Predicate<Double> predicate) {
        this.rules.add(predicate);
    }

    @Override
    public boolean test(Double value) {
        return this.rules.stream().allMatch(x -> x.test(value));
    }
}

