/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.solidcoding.validation.predicates.NumberConstraintPredicate;

public final class NumberPredicate
implements Predicate<Integer> {
    List<Predicate<Integer>> rules = new ArrayList<Predicate<Integer>>();

    private NumberPredicate() {
    }

    private NumberPredicate(Predicate<Integer> rule) {
        this.rules.add(rule);
    }

    public static NumberPredicate beANumber() {
        return new NumberPredicate();
    }

    public static NumberPredicate beANumber(int value) {
        return new NumberPredicate(x -> x == value);
    }

    public static NumberPredicate beANumber(Predicate<Integer> rule) {
        return new NumberPredicate(rule);
    }

    public static NumberPredicate beANumberOfLength(int amountOfDigits) {
        return NumberPredicate.beANumber(x -> String.valueOf(x).length() == amountOfDigits);
    }

    public NumberConstraintPredicate between(int first) {
        return new NumberConstraintPredicate(first, this);
    }

    public NumberPredicate containing(int integer, int ... integers) {
        this.rules.add(x -> String.valueOf(x).contains(String.valueOf(integer)));
        for (int i : integers) {
            this.rules.add(x -> String.valueOf(x).contains(String.valueOf(i)));
        }
        return this;
    }

    @Override
    public boolean test(Integer value) {
        return this.rules.stream().allMatch(x -> x.test(value));
    }
}

