/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.solidcoding.validation.predicates.StringLengthPredicate;

public final class StringPredicate
implements Predicate<String> {
    List<Predicate<String>> rules = new ArrayList<Predicate<String>>();

    StringPredicate() {
    }

    private StringPredicate(Predicate<String> rule) {
        this.rules.add(rule);
    }

    @SafeVarargs
    private StringPredicate(Predicate<String> ... rules) {
        Objects.requireNonNull(rules);
        this.rules.addAll(List.of(rules));
    }

    public static StringPredicate beAString() {
        return new StringPredicate();
    }

    public static StringPredicate beAString(String value) {
        return new StringPredicate((Predicate<String>)StringPredicate.beAString((String x) -> Objects.equals(x, value)));
    }

    public static StringPredicate beAString(Predicate<String> rule) {
        return new StringPredicate(rule);
    }

    public static StringPredicate beAStringWithLength(int length) {
        return StringPredicate.beAString((String x) -> x.length() == length);
    }

    public static StringPredicate beNumeric() {
        return StringPredicate.beAString((String x) -> x.chars().allMatch(Character::isDigit));
    }

    public static StringPredicate beNumeric(int amountOfDigits) {
        return new StringPredicate(x -> x.chars().allMatch(Character::isDigit), x -> x.length() == amountOfDigits);
    }

    public static StringPredicate beAlphabetic() {
        return StringPredicate.beAString((String x) -> x.chars().allMatch(Character::isAlphabetic));
    }

    public static StringPredicate beAlphabetic(int amountOfLetters) {
        return new StringPredicate(x -> x.chars().allMatch(Character::isAlphabetic), x -> x.length() == amountOfLetters);
    }

    public StringPredicate containing(CharSequence charSequence, CharSequence ... charSequences) {
        this.rules.add(x -> x.contains(charSequence));
        for (CharSequence c : charSequences) {
            this.rules.add(x -> x.contains(c));
        }
        return this;
    }

    public StringLengthPredicate withLengthBetween(int first) {
        return new StringLengthPredicate(first, this);
    }

    public StringPredicate that(Predicate<String> rule) {
        this.rules.add(rule);
        return this;
    }

    @Override
    public boolean test(String value) {
        return this.rules.stream().allMatch(x -> x.test(value));
    }
}

