/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.solidcoding.validation.api.contracts.Rule;

final class RuleDefinition<T>
implements Rule<T> {
    private final Predicate<T> predicate;
    private final String message;

    RuleDefinition(Predicate<T> predicate, String message) {
        this.predicate = predicate;
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean test(T value) {
        return this.predicate.test(value);
    }

    static final class Extended<T>
    implements Rule.Extended<T> {
        private final BiPredicate<T, Object> predicate;
        private final String message;

        Extended(BiPredicate<T, Object> predicate, String message) {
            this.predicate = predicate;
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public boolean test(T value, Object argument) {
            return this.predicate.test(value, argument);
        }
    }
}

