/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.solidcoding.validation.api.RuleDefinition;
import org.solidcoding.validation.api.contracts.Rule;
import org.solidcoding.validation.api.contracts.RuleBuilder;

final class RuleDefinitionBuilder<T>
implements RuleBuilder<T> {
    private final Predicate<T> predicate;

    RuleDefinitionBuilder(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Rule<T> otherwiseReport(String message, Object ... formatArguments) {
        String actualMessage = String.format(message, formatArguments);
        return new RuleDefinition<T>(this.predicate, actualMessage);
    }

    static final class Extended<T>
    implements RuleBuilder.Extended<T> {
        private final BiPredicate<T, Object> predicate;

        Extended(BiPredicate<T, Object> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Rule.Extended<T> otherwiseReport(String message, Object ... formatArguments) {
            String actualMessage = String.format(message, formatArguments);
            return new RuleDefinition.Extended<T>(this.predicate, actualMessage);
        }
    }
}

