/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.solidcoding.validation.api.Verifications;
import org.solidcoding.validation.api.contracts.LoggingValidator;
import org.solidcoding.validation.api.contracts.Rule;
import org.solidcoding.validation.api.contracts.Validator;

abstract class RuleDefinitionValidator<T>
implements Validator,
LoggingValidator {
    static final String DEFAULT_MESSAGE = "Nothing to report";
    protected final List<Rule<T>> ruleDefinitions = new ArrayList<Rule<T>>();
    protected final List<Rule.Extended<T>> xRuleDefinitions = new ArrayList<Rule.Extended<T>>();
    protected final T value;
    protected final Object argument;
    protected final boolean isExtended;
    protected String message = "Nothing to report";

    RuleDefinitionValidator(List<Rule<T>> ruleDefinitions, T value) {
        this.ruleDefinitions.addAll(ruleDefinitions);
        this.value = value;
        this.argument = null;
        this.isExtended = false;
    }

    RuleDefinitionValidator(List<Rule.Extended<T>> xRuleDefinitions, T value, Object argument) {
        this.xRuleDefinitions.addAll(xRuleDefinitions);
        this.value = value;
        this.argument = argument;
        this.isExtended = true;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean validate() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isValid = true;
        isValid = this.isExtended ? this.validateExtendedRules(stringBuilder) : this.validateRules(stringBuilder);
        if (!isValid) {
            this.message = stringBuilder.toString();
        }
        return isValid;
    }

    private boolean validateRules(StringBuilder stringBuilder) {
        boolean isValid = true;
        for (Rule<T> ruleDefinition : this.ruleDefinitions) {
            if (ruleDefinition.test(this.value)) continue;
            stringBuilder.append("Broken rule: ").append(ruleDefinition.getMessage()).append("\n");
            isValid = false;
        }
        return isValid;
    }

    private boolean validateExtendedRules(StringBuilder stringBuilder) {
        boolean isValid = true;
        for (Rule.Extended<T> biRuleDefinition : this.xRuleDefinitions) {
            if (biRuleDefinition.test(this.value, this.argument)) continue;
            stringBuilder.append("Broken rule: ").append(biRuleDefinition.getMessage()).append("\n");
            isValid = false;
        }
        return isValid;
    }

    @Override
    public boolean orElseLogMessage() {
        Logger logger = LoggerFactory.getLogger(Verifications.class);
        return this.orElseLogMessage(logger);
    }

    @Override
    public boolean orElseLogMessage(Logger logger) {
        boolean isValid = this.validate();
        if (!isValid) {
            logger.error(this.getMessage());
        }
        return isValid;
    }
}

