/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.solidcoding.validation.api.ContinuingRuleValidationBuilder;
import org.solidcoding.validation.api.ExtendedRuleArgumentAppender;
import org.solidcoding.validation.api.contracts.ArgumentAppender;
import org.solidcoding.validation.api.contracts.ContinuingValidationBuilder;
import org.solidcoding.validation.api.contracts.Rule;
import org.solidcoding.validation.api.contracts.ValidationBuilder;

final class RuleValidationBuilder<T>
implements ValidationBuilder<T> {
    private final T value;
    private final List<Rule<T>> ruleDefinitions;
    private final List<Rule.Extended<T>> xRuleDefinitions;

    RuleValidationBuilder(T value) {
        this.value = value;
        this.ruleDefinitions = new ArrayList<Rule<T>>();
        this.xRuleDefinitions = new ArrayList<Rule.Extended<T>>();
    }

    @Override
    public ContinuingValidationBuilder<T> compliesWith(Rule<T> rule) {
        this.ruleDefinitions.add(rule);
        return new ContinuingRuleValidationBuilder<T>(this.ruleDefinitions, this.value);
    }

    @Override
    public ContinuingValidationBuilder<T> compliesWith(Collection<Rule<T>> rules) {
        this.ruleDefinitions.addAll(rules);
        return new ContinuingRuleValidationBuilder<T>(this.ruleDefinitions, this.value);
    }

    @Override
    public ArgumentAppender<T> compliesWith(Rule.Extended<T> rule) {
        this.xRuleDefinitions.add(rule);
        return new ExtendedRuleArgumentAppender<T>(this.xRuleDefinitions, this.value);
    }
}

