/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.solidcoding.validation.api.RuleDefinitionValidator;
import org.solidcoding.validation.api.Verifications;
import org.solidcoding.validation.api.contracts.Rule;
import org.solidcoding.validation.api.contracts.VoidValidationBuilder;

final class VoidRuleValidatorBuilder<T>
extends RuleDefinitionValidator<T>
implements VoidValidationBuilder {
    private final Runnable runnable;

    VoidRuleValidatorBuilder(List<Rule<T>> ruleDefinitions, T value, Runnable runnable) {
        super(ruleDefinitions, value);
        this.runnable = runnable;
    }

    VoidRuleValidatorBuilder(List<Rule.Extended<T>> xRuleDefinitions, T value, Object argument, Runnable runnable) {
        super(xRuleDefinitions, value, argument);
        this.runnable = runnable;
    }

    @Override
    public <E extends RuntimeException> Void orElseThrow(Function<String, E> throwableFunction) {
        boolean isValid = this.validate();
        if (!isValid) {
            throw (RuntimeException)throwableFunction.apply(this.getMessage());
        }
        this.runnable.run();
        return null;
    }

    @Override
    public boolean orElseLogMessage() {
        Logger logger = LoggerFactory.getLogger(Verifications.class);
        return this.orElseLogMessage(logger);
    }

    @Override
    public boolean orElseLogMessage(Logger logger) {
        boolean isValid = this.validate();
        if (!isValid) {
            logger.error(this.getMessage());
        } else {
            this.runnable.run();
        }
        return isValid;
    }
}

