/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.function.Predicate;
import org.solidcoding.validation.predicates.ConstraintAppender;
import org.solidcoding.validation.predicates.DecimalNumberConstraintAppender;
import org.solidcoding.validation.predicates.ObjectPredicate;

public final class DecimalNumberPredicate
extends ObjectPredicate<Double> {
    private DecimalNumberPredicate(Predicate<Double> predicate) {
        super(predicate);
    }

    public static Predicate<Double> isNotNull() {
        return ObjectPredicate.isNotNull();
    }

    public static ConstraintAppender<Double, Predicate<Double>> isBetween(double first) {
        return new DecimalNumberConstraintAppender(first);
    }

    public static Predicate<Double> isEqualTo(double value) {
        return ObjectPredicate.isEqualTo(value);
    }

    public static Predicate<Double> contains(Integer value, Integer ... values) {
        Predicate<Double> predicate = x -> x.toString().contains(value.toString());
        for (Integer c : values) {
            predicate = predicate.and(x -> x.toString().contains(c.toString()));
        }
        return new DecimalNumberPredicate(predicate);
    }

    public static Predicate<Double> doesNotContain(Integer value, Integer ... values) {
        Predicate<Double> predicate = x -> !x.toString().contains(value.toString());
        for (Integer c : values) {
            predicate = predicate.and(x -> !x.toString().contains(c.toString()));
        }
        return new DecimalNumberPredicate(predicate);
    }
}

