/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.function.Predicate;
import org.solidcoding.validation.predicates.ConstraintAppender;
import org.solidcoding.validation.predicates.NumberConstraintAppender;
import org.solidcoding.validation.predicates.ObjectPredicate;

public final class NumberPredicate
extends ObjectPredicate<Integer> {
    private NumberPredicate(Predicate<Integer> predicate) {
        super(predicate);
    }

    public static Predicate<Integer> isNotNull() {
        return ObjectPredicate.isNotNull();
    }

    public static Predicate<Integer> isNull() {
        return ObjectPredicate.isNull();
    }

    public static Predicate<Integer> isEqualTo(int value) {
        return ObjectPredicate.isEqualTo(value);
    }

    public static Predicate<Integer> hasAmountOfDigits(int amountOfDigits) {
        return new NumberPredicate(x -> String.valueOf(x).length() == amountOfDigits);
    }

    public static ConstraintAppender<Integer, Predicate<Integer>> isBetween(int first) {
        return new NumberConstraintAppender(first);
    }

    public static Predicate<Integer> contains(Integer value, Integer ... values) {
        return ObjectPredicate.contains(value, values);
    }

    public static Predicate<Integer> doesNotContain(Integer value, Integer ... values) {
        return ObjectPredicate.doesNotContain(value, values);
    }
}

