/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.solidcoding.validation.predicates.PredicateAppender;

public class ObjectPredicate<T>
implements Predicate<T>,
PredicateAppender<T> {
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();

    private ObjectPredicate() {
    }

    protected ObjectPredicate(Predicate<T> predicate) {
        this.predicates.add(predicate);
    }

    public static <T> PredicateAppender<T> isA(Class<T> clazz) {
        return new ObjectPredicate<T>();
    }

    public static <T> PredicateAppender<T> isAn(Class<T> clazz) {
        return ObjectPredicate.isA(clazz);
    }

    public static <T> Predicate<T> isEqualTo(T value) {
        return new ObjectPredicate<Object>(x -> Objects.equals(x, value));
    }

    static <T> Predicate<T> isNotNull() {
        return new ObjectPredicate<Object>(Objects::nonNull);
    }

    static <T> Predicate<T> isNull() {
        return new ObjectPredicate<Object>(Objects::isNull);
    }

    static <T> Predicate<T> contains(Object value, Object ... values) {
        Predicate<Object> predicate = x -> x.toString().contains(value.toString());
        for (Object c : values) {
            predicate = predicate.and(x -> x.toString().contains(c.toString()));
        }
        return new ObjectPredicate<Object>(predicate);
    }

    static <T> Predicate<T> doesNotContain(Object value, Object ... values) {
        Predicate<Object> predicate = x -> !x.toString().contains(value.toString());
        for (Object c : values) {
            predicate = predicate.and(x -> !x.toString().contains(c.toString()));
        }
        return new ObjectPredicate<Object>(predicate);
    }

    @Override
    public boolean test(T value) {
        return this.predicates.stream().allMatch(x -> x.test(value));
    }
}

