/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.function.Predicate;
import org.solidcoding.validation.predicates.ConstraintAppender;
import org.solidcoding.validation.predicates.ObjectPredicate;
import org.solidcoding.validation.predicates.StringLengthConstraintAppender;

public final class StringPredicate
extends ObjectPredicate<String> {
    private StringPredicate(Predicate<String> predicate) {
        super(predicate);
    }

    public static Predicate<String> isNotNull() {
        return ObjectPredicate.isNotNull();
    }

    public static Predicate<String> contains(CharSequence value, CharSequence ... values) {
        return StringPredicate.contains(value, values);
    }

    public static Predicate<String> doesNotContain(CharSequence value, CharSequence ... values) {
        return StringPredicate.doesNotContain(value, values);
    }

    public static Predicate<String> isEqualTo(String value) {
        return ObjectPredicate.isEqualTo(value);
    }

    public static Predicate<String> hasALengthOf(int length) {
        return new StringPredicate(x -> x.length() == length);
    }

    public static Predicate<String> isNumeric() {
        return new StringPredicate(x -> x.chars().allMatch(Character::isDigit));
    }

    public static Predicate<String> isNotNumeric() {
        return new StringPredicate(x -> x.chars().anyMatch(Character::isAlphabetic));
    }

    public static Predicate<String> isAlphabetic() {
        return new StringPredicate(x -> x.chars().allMatch(Character::isAlphabetic));
    }

    public static Predicate<String> isNotAlphabetic() {
        return new StringPredicate(x -> x.chars().anyMatch(Character::isDigit));
    }

    public static ConstraintAppender<Integer, Predicate<String>> hasALengthBetween(int length) {
        return new StringLengthConstraintAppender(length);
    }
}

