/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.commons.components;

import develop.framework.commons.components.Range;
import develop.framework.commons.exceptions.RangeException;
import develop.framework.commons.utils.Sugar;
import java.text.ParseException;
import java.util.Date;
import lombok.NonNull;
import org.apache.commons.lang3.time.DateUtils;

public class DateRange
extends Range<Date> {
    public static final DateRange parse(@NonNull String fromDateStr, @NonNull String toDateStr, @NonNull String pattern) {
        Date to;
        Date from;
        if (fromDateStr == null) {
            throw new NullPointerException("fromDateStr");
        }
        if (toDateStr == null) {
            throw new NullPointerException("toDateStr");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        try {
            from = Sugar.useElseDefault(DateUtils.parseDate((String)fromDateStr, (String[])new String[]{pattern}), null);
        }
        catch (ParseException e) {
            throw new RangeException("\"%s\" invalid.", fromDateStr);
        }
        try {
            to = Sugar.useElseDefault(DateUtils.parseDate((String)toDateStr, (String[])new String[]{pattern}), null);
        }
        catch (ParseException e) {
            throw new RangeException("\"%s\" invalid.", fromDateStr);
        }
        return new DateRange(from, to);
    }

    public DateRange(Date from, Date to) {
        super(from, to);
    }
}

