/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class RestartContainerCmdImpl
extends AbstrDockerCmd<RestartContainerCmd, Void>
implements RestartContainerCmd {
    private String containerId;
    private Integer timeout = 10;

    public RestartContainerCmdImpl(RestartContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public RestartContainerCmd withContainerId(String containerId) {
        Objects.requireNonNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    public RestartContainerCmd withTimeout(Integer timeout) {
        Objects.requireNonNull(timeout, "timeout was not specified");
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout must be greater or equal 0");
        this.timeout = timeout;
        return this;
    }

    @Override
    public Void exec() throws NotFoundException {
        return (Void)super.exec();
    }
}

