/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.tools;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.Pattern;

public class Playground {
    static boolean validOption(String opt) {
        return "--ignorekeys".equals(opt) || "--expand".equals(opt) || "--compact".equals(opt) || "--frame".equals(opt) || "--normalize".equals(opt) || "--simplify".equals(opt) || "--debug".equals(opt) || "--base".equals(opt) || "--flatten".equals(opt) || "--fromRDF".equals(opt) || "--toRDF".equals(opt) || "--outputForm".equals(opt);
    }

    static boolean hasContext(String opt) {
        return "--compact".equals(opt) || "--frame".equals(opt) || "--flatten".equals(opt);
    }

    public static void main(String[] args) {
        boolean debug = false;
        try {
            if (args.length < 2 || !args[0].startsWith("--")) {
                Playground.usage();
            } else {
                JsonLdOptions opts = new JsonLdOptions("");
                Object inobj = null;
                Object ctxobj = null;
                String opt = null;
                int i = 0;
                while (i < args.length) {
                    if ("--debug".equals(args[i])) {
                        ++i;
                        debug = true;
                        continue;
                    }
                    if ("--base".equals(args[i])) {
                        int n = ++i;
                        ++i;
                        opts.setBase(args[n]);
                        continue;
                    }
                    if ("--outputForm".equals(args[i])) {
                        int n = ++i;
                        ++i;
                        opts.outputForm = args[n];
                        continue;
                    }
                    if (Playground.validOption(args[i])) {
                        File in;
                        if (opt != null) {
                            System.out.println("Error: can only do one operation on the input at a time");
                            Playground.usage();
                            return;
                        }
                        opt = args[i];
                        if (args.length <= ++i) {
                            System.out.println("Error: missing file names after argument " + args[i - 1]);
                            Playground.usage();
                            return;
                        }
                        if (!(in = new File(args[i++])).exists()) {
                            System.out.println("Error: file \"" + args[i - 1] + "\" doesn't exist");
                            Playground.usage();
                            return;
                        }
                        if (opts.getBase() == null || opts.getBase().equals("")) {
                            opts.setBase(in.toURI().toASCIIString());
                        }
                        if ("--fromRDF".equals(opt)) {
                            String line;
                            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), "UTF-8"));
                            inobj = "";
                            while ((line = buf.readLine()) != null) {
                                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                                inobj = (String)inobj + line + "\n";
                            }
                        } else {
                            inobj = JSONUtils.fromInputStream((InputStream)new FileInputStream(in));
                        }
                        if ("--fromRDF".equals(opt) || "--toRDF".equals(opt) || "--normalize".equals(opt)) {
                            if (args.length > i && !args[i].startsWith("--")) {
                                opts.format = args[i++];
                                if (Pattern.matches("^['\"`].*['\"`]$", opts.format)) {
                                    opts.format = opts.format.substring(1, opts.format.length() - 1);
                                }
                            }
                            if (opts.format != null && !"null".equals(opts.format)) continue;
                            opts.format = "application/nquads";
                            continue;
                        }
                        if (!Playground.hasContext(opt) || args.length <= i) continue;
                        if (!(in = new File(args[i++])).exists()) {
                            if (args[i - 1].startsWith("--")) {
                                --i;
                            } else {
                                System.out.println("Error: file \"" + args[i - 1] + "\" doesn't exist");
                                Playground.usage();
                                return;
                            }
                        }
                        ctxobj = JSONUtils.fromInputStream((InputStream)new FileInputStream(in));
                        continue;
                    }
                    System.out.println("Invalid option: " + args[i]);
                    Playground.usage();
                    return;
                }
                if (opt == null) {
                    System.out.println("Error: missing processing option");
                    Playground.usage();
                    return;
                }
                Object outobj = null;
                if ("--expand".equals(opt)) {
                    outobj = JsonLdProcessor.expand(inobj, (JsonLdOptions)opts);
                } else if ("--compact".equals(opt)) {
                    if (ctxobj == null) {
                        System.out.println("Error: The compaction context must not be null.");
                        Playground.usage();
                        return;
                    }
                    outobj = JsonLdProcessor.compact(inobj, ctxobj, (JsonLdOptions)opts);
                } else if ("--normalize".equals(opt)) {
                    outobj = JsonLdProcessor.normalize(inobj, (JsonLdOptions)opts);
                } else if ("--frame".equals(opt)) {
                    if (ctxobj != null && !(ctxobj instanceof Map)) {
                        System.out.println("Invalid JSON-LD syntax; a JSON-LD frame must be a single object.");
                        Playground.usage();
                        return;
                    }
                    outobj = JsonLdProcessor.frame(inobj, ctxobj, (JsonLdOptions)opts);
                } else if ("--flatten".equals(opt)) {
                    outobj = JsonLdProcessor.flatten(inobj, ctxobj, (JsonLdOptions)opts);
                } else if ("--toRDF".equals(opt)) {
                    opts.useNamespaces = true;
                    outobj = JsonLdProcessor.toRDF(inobj, (JsonLdOptions)opts);
                } else if ("--fromRDF".equals(opt)) {
                    outobj = JsonLdProcessor.fromRDF(inobj, (JsonLdOptions)opts);
                } else {
                    System.out.println("Error: invalid option \"" + opt + "\"");
                    Playground.usage();
                    return;
                }
                if ("--toRDF".equals(opt) || "--normalize".equals(opt)) {
                    System.out.println((String)outobj);
                } else {
                    System.out.println(JSONUtils.toPrettyString((Object)outobj));
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            if (e instanceof JsonLdError) {
                for (Map.Entry detail : ((JsonLdError)e).getDetails().entrySet()) {
                    System.out.println((String)detail.getKey() + ": " + detail.getValue());
                }
            }
            if (debug) {
                e.printStackTrace();
            }
            Playground.usage();
            return;
        }
    }

    private static void usage() {
        System.out.println("Usage: jsonldplayground <options>");
        System.out.println("\tinput: a filename or URL to the rdf input (in rdfxml or n3)");
        System.out.println("\toptions:");
        System.out.println("\t\t--ignorekeys <keys to ignore> : a (space separated) list of keys to ignore (e.g. @geojson)");
        System.out.println("\t\t--base <uri>: base URI");
        System.out.println("\t\t--debug: Print out stack traces when errors occur");
        System.out.println("\t\t--expand <input>: expand the input  JSON-LD");
        System.out.println("\t\t--compact <input> <context> : compact the input JSON-LD applying the optional context file");
        System.out.println("\t\t--normalize <input> <format> : normalize the input JSON-LD outputting as format (defaults to nquad)");
        System.out.println("\t\t--frame <input> <frame> : frame the input JSON-LD with the optional frame file");
        System.out.println("\t\t--flatten <input> <context> : flatten the input JSON-LD applying the optional context file");
        System.out.println("\t\t--fromRDF <input> <format> : generate JSON-LD from the input rdf (format defaults to nquads)");
        System.out.println("\t\t--toRDF <input> <format> : generate RDF from the input JSON-LD (format defaults to nquads)");
        System.out.println("\t\t--outputForm [compacted|expanded|flattened] : the way to output the results from fromRDF (defaults to expanded)");
        System.out.println("\t\t--simplify : simplify the input JSON-LD");
        System.exit(1);
    }
}

