/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.utils.Preconditions;
import java.io.Serializable;

public class Token
implements Serializable {
    private static final long serialVersionUID = 715000866082812683L;
    private final String token;
    private final String secret;
    private final String rawResponse;

    public Token(String token, String secret) {
        this(token, secret, null);
    }

    public Token(String token, String secret, String rawResponse) {
        Preconditions.checkNotNull(token, "Token can't be null");
        Preconditions.checkNotNull(secret, "Secret can't be null");
        this.token = token;
        this.secret = secret;
        this.rawResponse = rawResponse;
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRawResponse() {
        if (this.rawResponse == null) {
            throw new IllegalStateException("This token object was not constructed by ScribeJava and does not have a rawResponse");
        }
        return this.rawResponse;
    }

    public String getParameter(String parameter) {
        String value = null;
        for (String str : this.getRawResponse().split("&")) {
            if (!str.startsWith(parameter + '=')) continue;
            String[] part = str.split("=");
            if (part.length <= 1) break;
            value = part[1].trim();
            break;
        }
        return value;
    }

    public String toString() {
        return String.format("Token[%s , %s]", this.token, this.secret);
    }

    public boolean isEmpty() {
        return "".equals(this.token) && "".equals(this.secret);
    }

    public static Token empty() {
        return new Token("", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token that = (Token)o;
        return this.token.equals(that.getToken()) && this.secret.equals(that.getSecret());
    }

    public int hashCode() {
        return 31 * this.token.hashCode() + this.secret.hashCode();
    }
}

