/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.builder.api.OAuth2SignatureType;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.Map;

public abstract class DefaultApi20
implements BaseApi<OAuth20Service> {
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenJsonExtractor.instance();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public abstract String getAccessTokenEndpoint();

    public String getRefreshTokenEndpoint() {
        return this.getAccessTokenEndpoint();
    }

    protected abstract String getAuthorizationBaseUrl();

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        String state;
        String scope;
        ParameterList parameters = new ParameterList(additionalParams);
        parameters.add("response_type", config.getResponseType());
        parameters.add("client_id", config.getApiKey());
        String callback = config.getCallback();
        if (callback != null) {
            parameters.add("redirect_uri", callback);
        }
        if ((scope = config.getScope()) != null) {
            parameters.add("scope", scope);
        }
        if ((state = config.getState()) != null) {
            parameters.add("state", state);
        }
        return parameters.appendTo(this.getAuthorizationBaseUrl());
    }

    @Override
    public OAuth20Service createService(OAuthConfig config) {
        return new OAuth20Service(this, config);
    }

    public OAuth2SignatureType getSignatureType() {
        return OAuth2SignatureType.BEARER_AUTHORIZATION_REQUEST_HEADER_FIELD;
    }
}

