/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import java.nio.charset.Charset;
import java.util.Base64;

public enum ClientAuthenticationType {
    HTTP_BASIC_AUTHENTICATION_SCHEME{
        private final Base64.Encoder base64Encoder = Base64.getEncoder();

        @Override
        public void addClientAuthentication(OAuthRequest request, OAuthConfig config) {
            String apiKey = config.getApiKey();
            String apiSecret = config.getApiSecret();
            if (apiKey != null && apiSecret != null) {
                request.addHeader("Authorization", "Basic " + this.base64Encoder.encodeToString(String.format("%s:%s", apiKey, apiSecret).getBytes(Charset.forName("UTF-8"))));
            }
        }
    }
    ,
    REQUEST_BODY{

        @Override
        public void addClientAuthentication(OAuthRequest request, OAuthConfig config) {
            request.addParameter("client_id", config.getApiKey());
            String apiSecret = config.getApiSecret();
            if (apiSecret != null) {
                request.addParameter("client_secret", apiSecret);
            }
        }
    };


    public abstract void addClientAuthentication(OAuthRequest var1, OAuthConfig var2);
}

