/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.HeaderExtractor;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Map;
import java.util.stream.Collectors;

public class HeaderExtractorImpl
implements HeaderExtractor {
    private static final String PARAM_SEPARATOR = ", ";
    private static final String PREAMBLE = "OAuth ";

    @Override
    public String extract(OAuthRequest request) {
        this.checkPreconditions(request);
        Map<String, String> parameters = request.getOauthParameters();
        String paramsString = parameters.entrySet().stream().map(entry -> String.format("%s=\"%s\"", entry.getKey(), OAuthEncoder.encode((String)entry.getValue()))).collect(Collectors.joining(PARAM_SEPARATOR, PREAMBLE, ""));
        if (request.getRealm() == null || request.getRealm().isEmpty()) {
            return paramsString;
        }
        return paramsString + PARAM_SEPARATOR + String.format("%s=\"%s\"", "realm", request.getRealm());
    }

    private void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull(request, "Cannot extract a header from a null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}

