/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.Response;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class OAuth2AccessTokenJsonExtractorTest {
    private static final String RESPONSE = "'{ \"access_token\":\"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T3X\"}'";
    private final OAuth2AccessTokenJsonExtractor extractor = OAuth2AccessTokenJsonExtractor.instance();

    @Test
    public void shouldParseResponse() throws IOException {
        OAuth2AccessToken token = this.extractor.extract(OAuth2AccessTokenJsonExtractorTest.ok(RESPONSE));
        Assert.assertEquals((Object)token.getAccessToken(), (Object)"I0122HHJKLEM21F3WLPYHDKGKZULAUO4SGMV3ABKFTDT3T3X");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfForNullParameters() throws IOException {
        this.extractor.extract(OAuth2AccessTokenJsonExtractorTest.ok(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfForEmptyStrings() throws IOException {
        this.extractor.extract(OAuth2AccessTokenJsonExtractorTest.ok(""));
    }

    @Test
    public void shouldThrowExceptionIfResponseIsError() throws IOException {
        String body = "{\"error_description\":\"unknown, invalid, or expired refresh token\",\"error\":\"invalid_grant\"}";
        try {
            this.extractor.extract(OAuth2AccessTokenJsonExtractorTest.error("{\"error_description\":\"unknown, invalid, or expired refresh token\",\"error\":\"invalid_grant\"}"));
            Assert.fail();
        }
        catch (OAuth2AccessTokenErrorResponse oaer) {
            Assert.assertEquals((Object)OAuth2AccessTokenErrorResponse.ErrorCode.invalid_grant, (Object)oaer.getErrorCode());
            Assert.assertEquals((Object)"unknown, invalid, or expired refresh token", (Object)oaer.getErrorDescription());
        }
    }

    private static Response ok(String body) {
        return new Response(200, null, Collections.emptyMap(), body);
    }

    private static Response error(String body) {
        return new Response(400, null, Collections.emptyMap(), body);
    }
}

