/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuth20Service;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceBuilderTest {
    private ServiceBuilder builder;
    private ApiMock api;

    @Before
    public void setUp() {
        this.builder = new ServiceBuilder("will override api_key by another later in test");
        this.api = ApiMock.instance();
    }

    @Test
    public void shouldReturnConfigDefaultValues() {
        this.builder.apiKey("key").apiSecret("secret").build((BaseApi)this.api);
        OAuthConfig config = this.api.getConfig();
        Assert.assertEquals((Object)config.getApiKey(), (Object)"key");
        Assert.assertEquals((Object)config.getApiSecret(), (Object)"secret");
        Assert.assertEquals((Object)config.getCallback(), null);
    }

    @Test
    public void shouldAcceptValidCallbackUrl() {
        this.builder.apiKey("key").apiSecret("secret").callback("http://example.com").build((BaseApi)this.api);
        OAuthConfig config = this.api.getConfig();
        Assert.assertEquals((Object)config.getApiKey(), (Object)"key");
        Assert.assertEquals((Object)config.getApiSecret(), (Object)"secret");
        Assert.assertEquals((Object)config.getCallback(), (Object)"http://example.com");
    }

    @Test
    public void shouldAcceptNullAsCallback() {
        this.builder.apiKey("key").apiSecret("secret").callback(null).build((BaseApi)this.api);
    }

    @Test
    public void shouldAcceptAnScope() {
        this.builder.apiKey("key").apiSecret("secret").scope("rss-api").build((BaseApi)this.api);
        OAuthConfig config = this.api.getConfig();
        Assert.assertEquals((Object)config.getApiKey(), (Object)"key");
        Assert.assertEquals((Object)config.getApiSecret(), (Object)"secret");
        Assert.assertEquals((Object)config.getScope(), (Object)"rss-api");
    }

    private static class ApiMock
    extends DefaultApi20 {
        private OAuthConfig config;

        private ApiMock() {
        }

        private static ApiMock instance() {
            return new ApiMock();
        }

        private OAuthConfig getConfig() {
            return this.config;
        }

        public OAuth20Service createService(OAuthConfig config) {
            this.config = config;
            return null;
        }

        public String getAccessTokenEndpoint() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String getAuthorizationBaseUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

