/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.pkce;

import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PKCEService {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final int numberOFOctets;

    public PKCEService(int numberOFOctets) {
        this.numberOFOctets = numberOFOctets;
    }

    public PKCEService() {
        this(32);
    }

    public static PKCEService defaultInstance() {
        return DefaultInstanceHolder.INSTANCE;
    }

    public PKCE generatePKCE() {
        byte[] bytes = new byte[this.numberOFOctets];
        RANDOM.nextBytes(bytes);
        return this.generatePKCE(bytes);
    }

    public PKCE generatePKCE(byte[] randomBytes) {
        String codeVerifier = BASE_64_ENCODER.encodeToString(randomBytes);
        PKCE pkce = new PKCE();
        pkce.setCodeVerifier(codeVerifier);
        try {
            pkce.setCodeChallenge(pkce.getCodeChallengeMethod().transform2CodeChallenge(codeVerifier));
        }
        catch (NoSuchAlgorithmException nsaE) {
            pkce.setCodeChallengeMethod(PKCECodeChallengeMethod.plain);
            try {
                pkce.setCodeChallenge(PKCECodeChallengeMethod.plain.transform2CodeChallenge(codeVerifier));
            }
            catch (NoSuchAlgorithmException unrealE) {
                throw new IllegalStateException("It's just cannot be", unrealE);
            }
        }
        return pkce;
    }

    private static class DefaultInstanceHolder {
        private static final PKCEService INSTANCE = new PKCEService();

        private DefaultInstanceHolder() {
        }
    }
}

