/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.multipart;

import com.github.scribejava.core.httpclient.multipart.BodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.ByteArrayBodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.FileByteArrayBodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultipartPayload
extends BodyPartPayload {
    private static final String DEFAULT_SUBTYPE = "form-data";
    private final String boundary;
    private String preamble;
    private final List<BodyPartPayload> bodyParts = new ArrayList<BodyPartPayload>();
    private String epilogue;

    public MultipartPayload() {
        this(null, MultipartUtils.generateDefaultBoundary(), null);
    }

    public MultipartPayload(String boundary) {
        this(null, boundary, null);
    }

    public MultipartPayload(String subtype, String boundary) {
        this(subtype, boundary, null);
    }

    public MultipartPayload(Map<String, String> headers) {
        this(null, MultipartPayload.parseOrGenerateBoundary(headers), headers);
    }

    public MultipartPayload(String boundary, Map<String, String> headers) {
        this(null, boundary, headers);
    }

    public MultipartPayload(String subtype, String boundary, Map<String, String> headers) {
        super(MultipartPayload.composeHeaders(subtype, boundary, headers));
        this.boundary = boundary;
    }

    private static Map<String, String> composeHeaders(String subtype, String boundary, Map<String, String> headersIn) throws IllegalArgumentException {
        Map<String, String> headersOut;
        String contentTypeHeader;
        MultipartUtils.checkBoundarySyntax(boundary);
        String string = contentTypeHeader = headersIn == null ? null : headersIn.get("Content-Type");
        if (contentTypeHeader == null) {
            contentTypeHeader = "multipart/" + (subtype == null ? DEFAULT_SUBTYPE : subtype) + "; boundary=\"" + boundary + '\"';
            if (headersIn == null) {
                headersOut = Collections.singletonMap("Content-Type", contentTypeHeader);
            } else {
                headersOut = headersIn;
                headersOut.put("Content-Type", contentTypeHeader);
            }
        } else {
            headersOut = headersIn;
            String parsedBoundary = MultipartUtils.parseBoundaryFromHeader(contentTypeHeader);
            if (parsedBoundary == null) {
                headersOut.put("Content-Type", contentTypeHeader + "; boundary=\"" + boundary + '\"');
            } else if (!parsedBoundary.equals(boundary)) {
                throw new IllegalArgumentException("Different boundaries was passed in constructors. One as argument, second as header");
            }
        }
        return headersOut;
    }

    private static String parseOrGenerateBoundary(Map<String, String> headers) {
        String parsedBoundary = MultipartUtils.parseBoundaryFromHeader(headers.get("Content-Type"));
        return parsedBoundary == null ? MultipartUtils.generateDefaultBoundary() : parsedBoundary;
    }

    @Deprecated
    public void addFileBodyPart(byte[] fileContent) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent));
    }

    @Deprecated
    public void addFileBodyPart(byte[] fileContent, String name) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent, name));
    }

    @Deprecated
    public void addFileBodyPart(byte[] fileContent, String name, String filename) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(fileContent, name, filename));
    }

    @Deprecated
    public void addFileBodyPart(String contentType, byte[] fileContent) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent));
    }

    @Deprecated
    public void addFileBodyPart(String contentType, byte[] fileContent, String name) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent, name));
    }

    @Deprecated
    public void addFileBodyPart(String contentType, byte[] fileContent, String name, String filename) {
        this.addBodyPart(new FileByteArrayBodyPartPayload(contentType, fileContent, name, filename));
    }

    public void addBodyPart(BodyPartPayload bodyPartPayload) {
        this.bodyParts.add(bodyPartPayload);
    }

    public void addBodyPart(MultipartPayload multipartPayload) {
        if (multipartPayload.getBoundary().equals(this.boundary)) {
            throw new IllegalArgumentException("{'boundary'}={'" + this.boundary + "'} is the same for parent MultipartPayload and child");
        }
        this.bodyParts.add(multipartPayload);
    }

    @Deprecated
    public void addBodyPart(byte[] bodyPartPayload) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload));
    }

    @Deprecated
    public void addBodyPart(byte[] bodyPartPayload, String contentType) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload, contentType));
    }

    @Deprecated
    public void addBodyPart(byte[] bodyPartPayload, Map<String, String> headers) {
        this.addBodyPart(new ByteArrayBodyPartPayload(bodyPartPayload, headers));
    }

    public List<BodyPartPayload> getBodyParts() {
        return this.bodyParts;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }
}

