/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.utils.StreamUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractClientTest {
    private OAuthService oAuthService;

    @Before
    public void setUp() {
        this.oAuthService = new OAuth20Service(null, "test", "test", null, null, null, (OutputStream)System.out, null, null, this.createNewClient());
    }

    @After
    public void shutDown() throws Exception {
        this.oAuthService.close();
    }

    protected abstract HttpClient createNewClient();

    @Test
    public void shouldSendGetRequest() throws Exception {
        String expectedResponseBody = "response body for test shouldSendGetRequest";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldSendGetRequest"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.GET, baseUrl.toString());
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldSendGetRequest", (Object)response.getBody());
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"GET", (Object)recordedRequest.getMethod());
        server.shutdown();
    }

    @Test
    public void shouldSendPostWithApplicationXWwwFormUrlencodedRequestContentTypeHeader() throws Exception {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse());
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.POST, baseUrl.toString());
        ((Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS)).close();
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", (Object)recordedRequest.getHeader("Content-Type"));
        server.shutdown();
    }

    @Test
    public void shouldSendPostRequestWithEmptyBody() throws Exception {
        String expectedResponseBody = "response body for test shouldSendPostRequest";
        String expectedRequestBody = "";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldSendPostRequest"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.POST, baseUrl.toString());
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldSendPostRequest", (Object)response.getBody());
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
        Assert.assertEquals((Object)"", (Object)recordedRequest.getBody().readUtf8());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", (Object)recordedRequest.getHeader("Content-Type"));
        server.shutdown();
    }

    @Test
    public void shouldSendPostRequestWithStringBody() throws Exception {
        String expectedResponseBody = "response body for test shouldSendPostRequest";
        String expectedRequestBody = "request body";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldSendPostRequest"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.POST, baseUrl.toString());
        request.setPayload("request body");
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldSendPostRequest", (Object)response.getBody());
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
        Assert.assertEquals((Object)"request body", (Object)recordedRequest.getBody().readUtf8());
        String contentTypeHeader = recordedRequest.getHeader("Content-Type");
        Assert.assertNotNull((Object)contentTypeHeader);
        Assert.assertTrue((boolean)contentTypeHeader.startsWith("application/x-www-form-urlencoded"));
        server.shutdown();
    }

    @Test
    public void shouldSendPostRequestWithByteBodyBody() throws Exception {
        String expectedResponseBody = "response body for test shouldSendPostRequest";
        String expectedRequestBody = "request body";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldSendPostRequest"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.POST, baseUrl.toString());
        request.setPayload("request body".getBytes());
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldSendPostRequest", (Object)response.getBody());
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
        Assert.assertEquals((Object)"request body", (Object)recordedRequest.getBody().readUtf8());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", (Object)recordedRequest.getHeader("Content-Type"));
        server.shutdown();
    }

    @Test
    public void shouldSendPostRequestWithBodyParamsBody() throws Exception {
        String expectedResponseBody = "response body for test shouldSendPostRequest";
        String expectedRequestBodyParamName = "request_body_param_name";
        String expectedRequestBodyParamValue = "request_body_param_value";
        String expectedRequestBody = "request_body_param_name=request_body_param_value";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldSendPostRequest"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.POST, baseUrl.toString());
        request.addBodyParameter("request_body_param_name", "request_body_param_value");
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldSendPostRequest", (Object)response.getBody());
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"POST", (Object)recordedRequest.getMethod());
        Assert.assertEquals((Object)"request_body_param_name=request_body_param_value", (Object)recordedRequest.getBody().readUtf8());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", (Object)recordedRequest.getHeader("Content-Type"));
        server.shutdown();
    }

    @Test
    public void shouldReadResponseStream() throws Exception {
        String expectedResponseBody = "response body for test shouldReadResponseStream";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldReadResponseStream"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.GET, baseUrl.toString());
        try (Response response = (Response)this.oAuthService.execute(request, null).get(30L, TimeUnit.SECONDS);){
            Assert.assertEquals((Object)"response body for test shouldReadResponseStream", (Object)StreamUtils.getStreamContents((InputStream)response.getStream()));
        }
        RecordedRequest recordedRequest = server.takeRequest();
        Assert.assertEquals((Object)"GET", (Object)recordedRequest.getMethod());
        server.shutdown();
    }

    @Test
    public void shouldCallCallback() throws Exception {
        String expectedResponseBody = "response body for test shouldCallCallback";
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("response body for test shouldCallCallback"));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.GET, baseUrl.toString());
        TestCallback callback = new TestCallback();
        this.oAuthService.execute(request, (OAuthAsyncRequestCallback)callback).get();
        Assert.assertEquals((Object)"response body for test shouldCallCallback", (Object)callback.getResponse().getBody());
        server.shutdown();
    }

    @Test
    public void shouldPassErrors() throws Exception {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(500));
        server.start();
        HttpUrl baseUrl = server.url("/testUrl");
        OAuthRequest request = new OAuthRequest(Verb.GET, baseUrl.toString());
        TestCallback callback = new TestCallback();
        try (Response response = (Response)this.oAuthService.execute(request, (OAuthAsyncRequestCallback)callback).get();){
            Assert.assertEquals((long)500L, (long)response.getCode());
            Assert.assertEquals((long)500L, (long)callback.getResponse().getCode());
        }
        server.shutdown();
    }

    private static class TestCallback
    implements OAuthAsyncRequestCallback<Response> {
        private Response response;

        private TestCallback() {
        }

        public void onCompleted(Response response) {
            this.response = response;
        }

        public void onThrowable(Throwable throwable) {
        }

        public Response getResponse() {
            return this.response;
        }
    }
}

