/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.OAuth1AccessTokenExtractor;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.Response;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class OAuth1AccessTokenExtractorTest {
    private OAuth1AccessTokenExtractor extractor;

    @Before
    public void setUp() {
        this.extractor = OAuth1AccessTokenExtractor.instance();
    }

    @Test
    public void shouldExtractTokenFromOAuthStandardResponse() throws IOException {
        OAuth1Token extracted;
        String responseBody = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03";
        try (Response response = OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getTokenSecret());
    }

    @Test
    public void shouldExtractTokenFromInvertedOAuthStandardResponse() throws IOException {
        OAuth1Token extracted;
        String responseBody = "oauth_token_secret=hh5s93j4hdidpola&oauth_token=hdhd0244k9j7ao03";
        try (Response response = OAuth1AccessTokenExtractorTest.ok("oauth_token_secret=hh5s93j4hdidpola&oauth_token=hdhd0244k9j7ao03");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getTokenSecret());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getToken());
    }

    @Test
    public void shouldExtractTokenFromResponseWithCallbackConfirmed() throws IOException {
        OAuth1Token extracted;
        String responseBody = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03&callback_confirmed=true";
        try (Response response = OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03&callback_confirmed=true");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getTokenSecret());
    }

    @Test
    public void shouldExtractTokenWithEmptySecret() throws IOException {
        OAuth1Token extracted;
        String responseBody = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=";
        try (Response response = OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret=");){
            extracted = this.extractor.extract(response);
        }
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"", (Object)extracted.getTokenSecret());
    }

    public void shouldThrowExceptionIfTokenIsAbsent() throws IOException {
        String responseBody = "oauth_secret=hh5s93j4hdidpola&callback_confirmed=true";
        try (final Response response = OAuth1AccessTokenExtractorTest.ok("oauth_secret=hh5s93j4hdidpola&callback_confirmed=true");){
            Assert.assertThrows(OAuthException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    OAuth1AccessTokenExtractorTest.this.extractor.extract(response);
                }
            });
        }
    }

    public void shouldThrowExceptionIfSecretIsAbsent() throws IOException {
        String responseBody = "oauth_token=hh5s93j4hdidpola&callback_confirmed=true";
        try (final Response response = OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&callback_confirmed=true");){
            Assert.assertThrows(OAuthException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    OAuth1AccessTokenExtractorTest.this.extractor.extract(response);
                }
            });
        }
    }

    public void shouldThrowExceptionIfResponseIsNull() throws IOException {
        try (final Response response = OAuth1AccessTokenExtractorTest.ok(null);){
            Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    OAuth1AccessTokenExtractorTest.this.extractor.extract(response);
                }
            });
        }
    }

    public void shouldThrowExceptionIfResponseIsEmptyString() throws IOException {
        String responseBody = "";
        try (final Response response = OAuth1AccessTokenExtractorTest.ok("");){
            Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    OAuth1AccessTokenExtractorTest.this.extractor.extract(response);
                }
            });
        }
    }

    private static Response ok(String body) {
        return new Response(200, null, Collections.emptyMap(), body);
    }
}

