/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class StreamUtilsTest {
    private static final InputStream ALLWAYS_ERROR_INPUT_STREAM = new AllwaysErrorInputStream();

    @Test
    public void shouldCorrectlyDecodeAStream() throws IOException {
        String value = "expected";
        ByteArrayInputStream is = new ByteArrayInputStream("expected".getBytes());
        String decoded = StreamUtils.getStreamContents((InputStream)is);
        Assert.assertEquals((Object)"expected", (Object)decoded);
    }

    public void shouldFailForNullParameter() throws IOException {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamUtils.getStreamContents(null);
            }
        });
    }

    public void shouldFailWithBrokenStream() throws IOException {
        Assert.assertThrows(IOException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamUtils.getStreamContents((InputStream)ALLWAYS_ERROR_INPUT_STREAM);
            }
        });
    }

    private static class AllwaysErrorInputStream
    extends InputStream {
        private AllwaysErrorInputStream() {
        }

        @Override
        public int read() throws IOException {
            throw new IOException();
        }
    }
}

