/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLScalarType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.constraints.GraphQLScalars;
import graphql.validation.rules.ValidationEnvironment;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

abstract class AbstractDecimalMinMaxConstraint
extends AbstractDirectiveConstraint {
    public AbstractDecimalMinMaxConstraint(String name) {
        super(name);
    }

    public List<GraphQLScalarType> getApplicableTypes() {
        return GraphQLScalars.GRAPHQL_NUMBER_AND_STRING_TYPES;
    }

    @Override
    protected boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, GraphQLScalars.GRAPHQL_NUMBER_AND_STRING_TYPES);
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        boolean isOK;
        Object validatedValue = validationEnvironment.getValidatedValue();
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        String value = this.getStrArg(directive, "value");
        boolean inclusive = this.getBoolArg(directive, "inclusive");
        try {
            BigDecimal directiveBD = new BigDecimal(value);
            BigDecimal argBD = this.asBigDecimal(validatedValue);
            int comparisonResult = argBD.compareTo(directiveBD);
            isOK = this.isOK(inclusive, comparisonResult);
        }
        catch (NumberFormatException nfe) {
            isOK = false;
        }
        if (!isOK) {
            return this.mkError(validationEnvironment, "value", value, "inclusive", inclusive);
        }
        return Collections.emptyList();
    }

    protected abstract boolean isOK(boolean var1, int var2);

    @Override
    protected boolean appliesToListElements() {
        return true;
    }
}

