/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldCollector;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected ValuesResolver valuesResolver = new ValuesResolver();
    protected FieldCollector fieldCollector = new FieldCollector();

    public abstract ExecutionResult execute(ExecutionContext var1, GraphQLObjectType var2, Object var3, Map<String, List<Field>> var4);

    protected ExecutionResult resolveField(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, List<Field> fields) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, fields.get(0));
        if (fieldDef == null) {
            return null;
        }
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), fields.get(0).getArguments(), executionContext.getVariables());
        DataFetchingEnvironment environment = new DataFetchingEnvironment(source, argumentValues, executionContext.getRoot(), fields, fieldDef.getType(), parentType, executionContext.getGraphQLSchema());
        Object resolvedValue = null;
        try {
            resolvedValue = fieldDef.getDataFetcher().get(environment);
        }
        catch (Exception e) {
            log.info("Exception while fetching data", (Throwable)e);
            executionContext.addError(new ExceptionWhileDataFetching(e));
        }
        return this.completeValue(executionContext, fieldDef.getType(), fields, resolvedValue);
    }

    protected ExecutionResult completeValue(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields, Object result) {
        if (fieldType instanceof GraphQLNonNull) {
            GraphQLNonNull graphQLNonNull = (GraphQLNonNull)fieldType;
            ExecutionResult completed = this.completeValue(executionContext, graphQLNonNull.getWrappedType(), fields, result);
            if (completed == null) {
                throw new GraphQLException("Cannot return null for non-nullable type: " + fields);
            }
            return completed;
        }
        if (result == null) {
            return null;
        }
        if (fieldType instanceof GraphQLList) {
            return this.completeValueForList(executionContext, (GraphQLList)fieldType, fields, result);
        }
        if (fieldType instanceof GraphQLScalarType) {
            return this.completeValueForScalar((GraphQLScalarType)fieldType, result);
        }
        if (fieldType instanceof GraphQLEnumType) {
            return this.completeValueForEnum((GraphQLEnumType)fieldType, result);
        }
        GraphQLObjectType resolvedType = fieldType instanceof GraphQLInterfaceType ? this.resolveType((GraphQLInterfaceType)fieldType, result) : (fieldType instanceof GraphQLUnionType ? this.resolveType((GraphQLUnionType)fieldType, result) : (GraphQLObjectType)fieldType);
        LinkedHashMap<String, List<Field>> subFields = new LinkedHashMap<String, List<Field>>();
        ArrayList<String> visitedFragments = new ArrayList<String>();
        for (Field field : fields) {
            if (field.getSelectionSet() == null) continue;
            this.fieldCollector.collectFields(executionContext, resolvedType, field.getSelectionSet(), visitedFragments, subFields);
        }
        return executionContext.getExecutionStrategy().execute(executionContext, resolvedType, result, subFields);
    }

    private ExecutionResult completeValueForList(ExecutionContext executionContext, GraphQLList fieldType, List<Field> fields, Object result) {
        if (result.getClass().isArray()) {
            result = Arrays.asList((Object[])result);
        }
        return this.completeValueForList(executionContext, fieldType, fields, result);
    }

    protected GraphQLObjectType resolveType(GraphQLInterfaceType graphQLInterfaceType, Object value) {
        GraphQLObjectType result = graphQLInterfaceType.getTypeResolver().getType(value);
        if (result == null) {
            throw new GraphQLException("could not determine type");
        }
        return result;
    }

    protected GraphQLObjectType resolveType(GraphQLUnionType graphQLUnionType, Object value) {
        GraphQLObjectType result = graphQLUnionType.getTypeResolver().getType(value);
        if (result == null) {
            throw new GraphQLException("could not determine type");
        }
        return result;
    }

    protected ExecutionResult completeValueForEnum(GraphQLEnumType enumType, Object result) {
        return new ExecutionResultImpl(enumType.getCoercing().serialize(result), null);
    }

    protected ExecutionResult completeValueForScalar(GraphQLScalarType scalarType, Object result) {
        return new ExecutionResultImpl(scalarType.getCoercing().serialize(result), null);
    }

    protected ExecutionResult completeValueForList(ExecutionContext executionContext, GraphQLList fieldType, List<Field> fields, List<Object> result) {
        ArrayList<Object> completedResults = new ArrayList<Object>();
        for (Object item : result) {
            ExecutionResult completedValue = this.completeValue(executionContext, fieldType.getWrappedType(), fields, item);
            completedResults.add(completedValue != null ? completedValue.getData() : null);
        }
        return new ExecutionResultImpl(completedResults, null);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        if (schema.getQueryType() == parentType) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return Introspection.SchemaMetaFieldDef;
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return Introspection.TypeMetaFieldDef;
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return Introspection.TypeNameMetaFieldDef;
        }
        GraphQLFieldDefinition fieldDefinition = parentType.getFieldDefinition(field.getName());
        if (fieldDefinition == null) {
            throw new GraphQLException("unknown field " + field.getName());
        }
        return fieldDefinition;
    }
}

