/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.execution.ConditionalNodes;
import graphql.execution.ExecutionContext;
import graphql.execution.TypeFromAST;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FieldCollector {
    private ConditionalNodes conditionalNodes;
    private SchemaUtil schemaUtil = new SchemaUtil();

    public FieldCollector() {
        this.conditionalNodes = new ConditionalNodes();
    }

    public void collectFields(ExecutionContext executionContext, GraphQLObjectType type, SelectionSet selectionSet, List<String> visitedFragments, Map<String, List<Field>> fields) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectField(executionContext, fields, (Field)selection);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectInlineFragment(executionContext, type, visitedFragments, fields, (InlineFragment)selection);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.collectFragmentSpread(executionContext, type, visitedFragments, fields, (FragmentSpread)selection);
        }
    }

    private void collectFragmentSpread(ExecutionContext executionContext, GraphQLObjectType type, List<String> visitedFragments, Map<String, List<Field>> fields, FragmentSpread fragmentSpread) {
        if (visitedFragments.contains(fragmentSpread.getName())) {
            return;
        }
        if (!this.conditionalNodes.shouldInclude(executionContext, fragmentSpread.getDirectives())) {
            return;
        }
        visitedFragments.add(fragmentSpread.getName());
        FragmentDefinition fragmentDefinition = executionContext.getFragment(fragmentSpread.getName());
        if (!this.conditionalNodes.shouldInclude(executionContext, fragmentDefinition.getDirectives())) {
            return;
        }
        if (!this.doesFragmentConditionMatch(executionContext, fragmentDefinition, type)) {
            return;
        }
        this.collectFields(executionContext, type, fragmentDefinition.getSelectionSet(), visitedFragments, fields);
    }

    private void collectInlineFragment(ExecutionContext executionContext, GraphQLObjectType type, List<String> visitedFragments, Map<String, List<Field>> fields, InlineFragment inlineFragment) {
        if (!this.conditionalNodes.shouldInclude(executionContext, inlineFragment.getDirectives()) || !this.doesFragmentConditionMatch(executionContext, inlineFragment, type)) {
            return;
        }
        this.collectFields(executionContext, type, inlineFragment.getSelectionSet(), visitedFragments, fields);
    }

    private void collectField(ExecutionContext executionContext, Map<String, List<Field>> fields, Field field) {
        if (!this.conditionalNodes.shouldInclude(executionContext, field.getDirectives())) {
            return;
        }
        String name = this.getFieldEntryKey(field);
        if (!fields.containsKey(name)) {
            fields.put(name, new ArrayList());
        }
        fields.get(name).add(field);
    }

    private String getFieldEntryKey(Field field) {
        if (field.getAlias() != null) {
            return field.getAlias();
        }
        return field.getName();
    }

    private boolean doesFragmentConditionMatch(ExecutionContext executionContext, InlineFragment inlineFragment, GraphQLObjectType type) {
        GraphQLType conditionType = TypeFromAST.getTypeFromAST(executionContext.getGraphQLSchema(), inlineFragment.getTypeCondition());
        return this.checkTypeCondition(executionContext, type, conditionType);
    }

    private boolean doesFragmentConditionMatch(ExecutionContext executionContext, FragmentDefinition fragmentDefinition, GraphQLObjectType type) {
        GraphQLType conditionType = TypeFromAST.getTypeFromAST(executionContext.getGraphQLSchema(), fragmentDefinition.getTypeCondition());
        return this.checkTypeCondition(executionContext, type, conditionType);
    }

    private boolean checkTypeCondition(ExecutionContext executionContext, GraphQLObjectType type, GraphQLType conditionType) {
        if (conditionType.equals(type)) {
            return true;
        }
        if (conditionType instanceof GraphQLInterfaceType) {
            List<GraphQLObjectType> implementations = this.schemaUtil.findImplementations(executionContext.getGraphQLSchema(), (GraphQLInterfaceType)conditionType);
            return implementations.contains(type);
        }
        if (conditionType instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)conditionType).getTypes().contains(type);
        }
        return false;
    }
}

