/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.batched;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.batched.BatchedDataFetcher;
import graphql.execution.batched.BatchedDataFetcherFactory;
import graphql.execution.batched.ChildDataCollector;
import graphql.execution.batched.GraphQLExecutionNode;
import graphql.execution.batched.GraphQLExecutionNodeDatum;
import graphql.execution.batched.GraphQLExecutionNodeValue;
import graphql.execution.batched.GraphQLExecutionResultList;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedExecutionStrategy
extends ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(BatchedExecutionStrategy.class);
    private final BatchedDataFetcherFactory batchingFactory = new BatchedDataFetcherFactory();

    @Override
    public ExecutionResult execute(ExecutionContext executionContext, GraphQLObjectType parentType, Object source, Map<String, List<Field>> fields) {
        GraphQLExecutionNodeDatum data = new GraphQLExecutionNodeDatum(new LinkedHashMap<String, Object>(), source);
        GraphQLExecutionNode root = new GraphQLExecutionNode(parentType, fields, Collections.singletonList(data));
        return this.execute(executionContext, root);
    }

    private ExecutionResult execute(ExecutionContext executionContext, GraphQLExecutionNode root) {
        ArrayDeque<GraphQLExecutionNode> nodes = new ArrayDeque<GraphQLExecutionNode>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            GraphQLExecutionNode node = (GraphQLExecutionNode)nodes.poll();
            for (String fieldName : node.getFields().keySet()) {
                List<Field> fieldList = node.getFields().get(fieldName);
                List<GraphQLExecutionNode> childNodes = this.resolveField(executionContext, node.getParentType(), node.getData(), fieldName, fieldList);
                nodes.addAll(childNodes);
            }
        }
        return new ExecutionResultImpl(this.getOnlyElement(root.getData()).getParentResult(), executionContext.getErrors());
    }

    private GraphQLExecutionNodeDatum getOnlyElement(List<GraphQLExecutionNodeDatum> list) {
        return list.get(0);
    }

    private List<GraphQLExecutionNode> resolveField(ExecutionContext executionContext, GraphQLObjectType parentType, List<GraphQLExecutionNodeDatum> nodeData, String fieldName, List<Field> fields) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, fields.get(0));
        if (fieldDef == null) {
            return Collections.emptyList();
        }
        List<GraphQLExecutionNodeValue> values = this.fetchData(executionContext, parentType, nodeData, fields, fieldDef);
        return this.completeValues(executionContext, parentType, values, fieldName, fields, fieldDef.getType());
    }

    private List<GraphQLExecutionNode> completeValues(ExecutionContext executionContext, GraphQLObjectType parentType, List<GraphQLExecutionNodeValue> values, String fieldName, List<Field> fields, GraphQLOutputType outputType) {
        GraphQLType fieldType = this.handleNonNullType(outputType, values, parentType, fields);
        if (this.isPrimitive(fieldType)) {
            this.handlePrimitives(values, fieldName, fieldType);
            return Collections.emptyList();
        }
        if (this.isObject(fieldType)) {
            return this.handleObject(executionContext, values, fieldName, fields, fieldType);
        }
        if (this.isList(fieldType)) {
            return this.handleList(executionContext, values, fieldName, fields, parentType, (GraphQLList)fieldType);
        }
        throw new IllegalArgumentException("Unrecognized type: " + fieldType);
    }

    private List<GraphQLExecutionNode> handleList(ExecutionContext executionContext, List<GraphQLExecutionNodeValue> values, String fieldName, List<Field> fields, GraphQLObjectType parentType, GraphQLList listType) {
        ArrayList<GraphQLExecutionNodeValue> flattenedNodeValues = new ArrayList<GraphQLExecutionNodeValue>();
        for (GraphQLExecutionNodeValue value : values) {
            if (value.getValue() == null) {
                value.getResultContainer().putResult(fieldName, null);
                continue;
            }
            GraphQLExecutionResultList flattenedDatum = value.getResultContainer().createAndPutEmptyChildList(fieldName);
            for (Object rawValue : (List)value.getValue()) {
                flattenedNodeValues.add(new GraphQLExecutionNodeValue(flattenedDatum, rawValue));
            }
        }
        GraphQLOutputType subType = (GraphQLOutputType)listType.getWrappedType();
        return this.completeValues(executionContext, parentType, flattenedNodeValues, fieldName, fields, subType);
    }

    private List<GraphQLExecutionNode> handleObject(ExecutionContext executionContext, List<GraphQLExecutionNodeValue> values, String fieldName, List<Field> fields, GraphQLType fieldType) {
        ChildDataCollector collector = this.createAndPopulateChildData(values, fieldName, fieldType);
        List<GraphQLExecutionNode> childNodes = this.createChildNodes(executionContext, fields, collector);
        return childNodes;
    }

    private List<GraphQLExecutionNode> createChildNodes(ExecutionContext executionContext, List<Field> fields, ChildDataCollector collector) {
        ArrayList<GraphQLExecutionNode> childNodes = new ArrayList<GraphQLExecutionNode>();
        for (ChildDataCollector.Entry entry : collector.getEntries()) {
            Map<String, List<Field>> childFields = this.getChildFields(executionContext, entry.getObjectType(), fields);
            childNodes.add(new GraphQLExecutionNode(entry.getObjectType(), childFields, entry.getData()));
        }
        return childNodes;
    }

    private ChildDataCollector createAndPopulateChildData(List<GraphQLExecutionNodeValue> values, String fieldName, GraphQLType fieldType) {
        ChildDataCollector collector = new ChildDataCollector();
        for (GraphQLExecutionNodeValue value : values) {
            if (value.getValue() == null) {
                value.getResultContainer().putResult(fieldName, null);
                continue;
            }
            GraphQLExecutionNodeDatum childDatum = value.getResultContainer().createAndPutChildDatum(fieldName, value.getValue());
            GraphQLObjectType graphQLObjectType = this.getGraphQLObjectType(fieldType, value.getValue());
            collector.putChildData(graphQLObjectType, childDatum);
        }
        return collector;
    }

    private GraphQLType handleNonNullType(GraphQLType fieldType, List<GraphQLExecutionNodeValue> values, GraphQLObjectType parentType, List<Field> fields) {
        if (this.isNonNull(fieldType)) {
            for (GraphQLExecutionNodeValue value : values) {
                if (value.getValue() != null) continue;
                throw new GraphQLException("Found null value for non-null type with parent: '" + parentType.getName() + "' for fields: " + fields);
            }
            while (this.isNonNull(fieldType)) {
                fieldType = ((GraphQLNonNull)fieldType).getWrappedType();
            }
        }
        return fieldType;
    }

    private boolean isNonNull(GraphQLType fieldType) {
        return fieldType instanceof GraphQLNonNull;
    }

    private Map<String, List<Field>> getChildFields(ExecutionContext executionContext, GraphQLObjectType resolvedType, List<Field> fields) {
        LinkedHashMap<String, List<Field>> subFields = new LinkedHashMap<String, List<Field>>();
        ArrayList<String> visitedFragments = new ArrayList<String>();
        for (Field field : fields) {
            if (field.getSelectionSet() == null) continue;
            this.fieldCollector.collectFields(executionContext, resolvedType, field.getSelectionSet(), visitedFragments, subFields);
        }
        return subFields;
    }

    private GraphQLObjectType getGraphQLObjectType(GraphQLType fieldType, Object value) {
        GraphQLObjectType resolvedType = null;
        if (fieldType instanceof GraphQLInterfaceType) {
            resolvedType = this.resolveType((GraphQLInterfaceType)fieldType, value);
        } else if (fieldType instanceof GraphQLUnionType) {
            resolvedType = this.resolveType((GraphQLUnionType)fieldType, value);
        } else if (fieldType instanceof GraphQLObjectType) {
            resolvedType = (GraphQLObjectType)fieldType;
        }
        return resolvedType;
    }

    private void handlePrimitives(List<GraphQLExecutionNodeValue> values, String fieldName, GraphQLType type) {
        for (GraphQLExecutionNodeValue value : values) {
            Object coercedValue = this.coerce(type, value.getValue());
            value.getResultContainer().putResult(fieldName, coercedValue);
        }
    }

    private Object coerce(GraphQLType type, Object value) {
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).getCoercing().serialize(value);
        }
        return ((GraphQLScalarType)type).getCoercing().serialize(value);
    }

    private boolean isList(GraphQLType type) {
        return type instanceof GraphQLList;
    }

    private boolean isPrimitive(GraphQLType type) {
        return type instanceof GraphQLScalarType || type instanceof GraphQLEnumType;
    }

    private boolean isObject(GraphQLType type) {
        return type instanceof GraphQLObjectType || type instanceof GraphQLInterfaceType || type instanceof GraphQLUnionType;
    }

    private List<GraphQLExecutionNodeValue> fetchData(ExecutionContext executionContext, GraphQLObjectType parentType, List<GraphQLExecutionNodeDatum> nodeData, List<Field> fields, GraphQLFieldDefinition fieldDef) {
        int i;
        List values;
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), fields.get(0).getArguments(), executionContext.getVariables());
        ArrayList<Object> sources = new ArrayList<Object>();
        for (GraphQLExecutionNodeDatum n : nodeData) {
            sources.add(n.getSource());
        }
        DataFetchingEnvironment environment = new DataFetchingEnvironment(sources, argumentValues, executionContext.getRoot(), fields, fieldDef.getType(), parentType, executionContext.getGraphQLSchema());
        try {
            values = (List)this.getDataFetcher(fieldDef).get(environment);
        }
        catch (Exception e) {
            values = new ArrayList();
            for (i = 0; i < nodeData.size(); ++i) {
                values.add(null);
            }
            log.info("Exception while fetching data", (Throwable)e);
            executionContext.addError(new ExceptionWhileDataFetching(e));
        }
        assert (nodeData.size() == values.size());
        ArrayList<GraphQLExecutionNodeValue> retVal = new ArrayList<GraphQLExecutionNodeValue>();
        for (i = 0; i < nodeData.size(); ++i) {
            retVal.add(new GraphQLExecutionNodeValue(nodeData.get(i), values.get(i)));
        }
        return retVal;
    }

    private BatchedDataFetcher getDataFetcher(GraphQLFieldDefinition fieldDef) {
        DataFetcher supplied = fieldDef.getDataFetcher();
        return this.batchingFactory.create(supplied);
    }
}

