/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class PropertyDataFetcher
implements DataFetcher {
    private final String propertyName;

    public PropertyDataFetcher(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Object get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return ((Map)source).get(this.propertyName);
        }
        return this.getPropertyViaGetter(source, environment.getFieldType());
    }

    private Object getPropertyViaGetter(Object object, GraphQLOutputType outputType) {
        String prefix = this.isBooleanProperty(outputType) ? "is" : "get";
        String getterName = prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        try {
            Method method = object.getClass().getMethod(getterName, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLOutputType outputType) {
        if (outputType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (outputType instanceof GraphQLNonNull) {
            return ((GraphQLNonNull)outputType).getWrappedType() == Scalars.GraphQLBoolean;
        }
        return false;
    }
}

