/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.ShouldNotHappenException;
import graphql.execution.TypeFromAST;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.SchemaUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Collections;
import java.util.List;

public class PossibleFragmentSpreads
extends AbstractRule {
    public PossibleFragmentSpreads(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkInlineFragment(InlineFragment inlineFragment) {
        GraphQLOutputType fragType = this.getValidationContext().getOutputType();
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (fragType == null || parentType == null) {
            return;
        }
        if (!this.doTypesOverlap(fragType, parentType)) {
            String message = String.format("Fragment cannot be spread here as objects of type %s can never be of type %s", parentType, fragType);
            this.addError(new ValidationError(ValidationErrorType.InvalidFragmentType, inlineFragment.getSourceLocation(), message));
        }
    }

    @Override
    public void checkFragmentSpread(FragmentSpread fragmentSpread) {
        FragmentDefinition fragment = this.getValidationContext().getFragment(fragmentSpread.getName());
        if (fragment == null) {
            return;
        }
        GraphQLType typeCondition = TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), fragment.getTypeCondition());
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (typeCondition == null || parentType == null) {
            return;
        }
        if (!this.doTypesOverlap(typeCondition, parentType)) {
            String message = String.format("Fragment %s cannot be spread here as objects of type %s can never be of type %s", fragmentSpread.getName(), parentType, typeCondition);
            this.addError(new ValidationError(ValidationErrorType.InvalidFragmentType, fragmentSpread.getSourceLocation(), message));
        }
    }

    private boolean doTypesOverlap(GraphQLType type, GraphQLCompositeType parent) {
        List<GraphQLType> possibleConditionTypes;
        List<GraphQLType> possibleParentTypes;
        if (type == parent) {
            return true;
        }
        if (parent instanceof GraphQLObjectType) {
            possibleParentTypes = Collections.singletonList(parent);
        } else if (parent instanceof GraphQLInterfaceType) {
            possibleParentTypes = new SchemaUtil().findImplementations(this.getValidationContext().getSchema(), (GraphQLInterfaceType)parent);
        } else if (parent instanceof GraphQLUnionType) {
            possibleParentTypes = ((GraphQLUnionType)parent).getTypes();
        } else {
            throw new ShouldNotHappenException();
        }
        if (type instanceof GraphQLObjectType) {
            possibleConditionTypes = Collections.singletonList(type);
        } else if (type instanceof GraphQLInterfaceType) {
            possibleConditionTypes = new SchemaUtil().findImplementations(this.getValidationContext().getSchema(), (GraphQLInterfaceType)type);
        } else if (type instanceof GraphQLUnionType) {
            possibleConditionTypes = ((GraphQLUnionType)type).getTypes();
        } else {
            throw new ShouldNotHappenException();
        }
        return !Collections.disjoint(possibleParentTypes, possibleConditionTypes);
    }
}

