/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.List;

public class Introspection {
    public static GraphQLEnumType __TypeKind = GraphQLEnumType.newEnum().name("__TypeKind").description("An enum describing what kind of type a given __Type is").value("SCALAR", (Object)TypeKind.SCALAR, "Indicates this type is a scalar.").value("OBJECT", (Object)TypeKind.OBJECT, "Indicates this type is an object. `fields` and `interfaces` are valid fields.").value("INTERFACE", (Object)TypeKind.INTERFACE, "Indicates this type is an interface. `fields` and `possibleTypes` are valid fields.").value("UNION", (Object)TypeKind.UNION, "Indicates this type is a union. `possibleTypes` is a valid field.").value("ENUM", (Object)TypeKind.ENUM, "Indicates this type is an enum. `enumValues` is a valid field.").value("INPUT_OBJECT", (Object)TypeKind.INPUT_OBJECT, "Indicates this type is an input object. `inputFields` is a valid field.").value("LIST", (Object)TypeKind.LIST, "Indicates this type is a list. `ofType` is a valid field.").value("NON_NULL", (Object)TypeKind.NON_NULL, "Indicates this type is a non-null. `ofType` is a valid field.").build();
    public static DataFetcher kindDataFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            if (type instanceof GraphQLScalarType) {
                return TypeKind.SCALAR;
            }
            if (type instanceof GraphQLObjectType) {
                return TypeKind.OBJECT;
            }
            if (type instanceof GraphQLInterfaceType) {
                return TypeKind.INTERFACE;
            }
            if (type instanceof GraphQLUnionType) {
                return TypeKind.UNION;
            }
            if (type instanceof GraphQLEnumType) {
                return TypeKind.ENUM;
            }
            if (type instanceof GraphQLInputObjectType) {
                return TypeKind.INPUT_OBJECT;
            }
            if (type instanceof GraphQLList) {
                return TypeKind.LIST;
            }
            if (type instanceof GraphQLNonNull) {
                return TypeKind.NON_NULL;
            }
            throw new RuntimeException("Unknown kind of type: " + type);
        }
    };
    public static GraphQLObjectType __InputValue = GraphQLObjectType.newObject().name("__InputValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(new GraphQLNonNull(new GraphQLTypeReference("__Type"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("defaultValue").type(Scalars.GraphQLString).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            if (environment.getSource() instanceof GraphQLArgument) {
                GraphQLArgument inputField = (GraphQLArgument)environment.getSource();
                return inputField.getDefaultValue() != null ? inputField.getDefaultValue().toString() : null;
            }
            if (environment.getSource() instanceof GraphQLInputObjectField) {
                GraphQLInputObjectField inputField = (GraphQLInputObjectField)environment.getSource();
                return inputField.getDefaultValue() != null ? inputField.getDefaultValue().toString() : null;
            }
            return null;
        }
    }).build()).build();
    public static GraphQLObjectType __Field = GraphQLObjectType.newObject().name("__Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__InputValue)))).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            return ((GraphQLFieldDefinition)type).getArguments();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(new GraphQLNonNull(new GraphQLTypeReference("__Type"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(new GraphQLNonNull(Scalars.GraphQLBoolean)).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            return ((GraphQLFieldDefinition)type).isDeprecated();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString).build()).build();
    public static GraphQLObjectType __EnumValue = GraphQLObjectType.newObject().name("__EnumValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(new GraphQLNonNull(Scalars.GraphQLBoolean)).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            GraphQLEnumValueDefinition enumValue = (GraphQLEnumValueDefinition)environment.getSource();
            return enumValue.isDeprecated();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString).build()).build();
    public static DataFetcher fieldsFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            if (type instanceof GraphQLFieldsContainer) {
                GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)type;
                List<GraphQLFieldDefinition> fieldDefinitions = fieldsContainer.getFieldDefinitions();
                if (includeDeprecated) {
                    return fieldDefinitions;
                }
                ArrayList<GraphQLFieldDefinition> filtered = new ArrayList<GraphQLFieldDefinition>(fieldDefinitions);
                for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
                    if (!fieldDefinition.isDeprecated()) continue;
                    filtered.remove(fieldDefinition);
                }
                return filtered;
            }
            return null;
        }
    };
    public static DataFetcher interfacesFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            if (type instanceof GraphQLObjectType) {
                return ((GraphQLObjectType)type).getInterfaces();
            }
            return null;
        }
    };
    public static DataFetcher possibleTypesFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            if (type instanceof GraphQLInterfaceType) {
                return new SchemaUtil().findImplementations(environment.getGraphQLSchema(), (GraphQLInterfaceType)type);
            }
            if (type instanceof GraphQLUnionType) {
                return ((GraphQLUnionType)type).getTypes();
            }
            return null;
        }
    };
    public static DataFetcher enumValuesTypesFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            if (type instanceof GraphQLEnumType) {
                List<GraphQLEnumValueDefinition> values = ((GraphQLEnumType)type).getValues();
                if (includeDeprecated) {
                    return values;
                }
                ArrayList<GraphQLEnumValueDefinition> filtered = new ArrayList<GraphQLEnumValueDefinition>(values);
                for (GraphQLEnumValueDefinition valueDefinition : values) {
                    if (!valueDefinition.isDeprecated()) continue;
                    filtered.remove(valueDefinition);
                }
                return filtered;
            }
            return null;
        }
    };
    public static DataFetcher inputFieldsFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            if (type instanceof GraphQLInputObjectType) {
                return ((GraphQLInputObjectType)type).getFields();
            }
            return null;
        }
    };
    public static DataFetcher OfTypeFetcher = new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            Object type = environment.getSource();
            if (type instanceof GraphQLList) {
                return ((GraphQLList)type).getWrappedType();
            }
            if (type instanceof GraphQLNonNull) {
                return ((GraphQLNonNull)type).getWrappedType();
            }
            return null;
        }
    };
    public static GraphQLObjectType __Type = GraphQLObjectType.newObject().name("__Type").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type(new GraphQLNonNull(__TypeKind)).dataFetcher(kindDataFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type(new GraphQLList(new GraphQLNonNull(__Field))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false).build()).dataFetcher(fieldsFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("interfaces").type(new GraphQLList(new GraphQLNonNull(new GraphQLTypeReference("__Type")))).dataFetcher(interfacesFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("possibleTypes").type(new GraphQLList(new GraphQLNonNull(new GraphQLTypeReference("__Type")))).dataFetcher(possibleTypesFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("enumValues").type(new GraphQLList(new GraphQLNonNull(__EnumValue))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false).build()).dataFetcher(enumValuesTypesFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("inputFields").type(new GraphQLList(new GraphQLNonNull(__InputValue))).dataFetcher(inputFieldsFetcher).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ofType").type(new GraphQLTypeReference("__Type")).dataFetcher(OfTypeFetcher).build()).build();
    public static GraphQLObjectType __Directive = GraphQLObjectType.newObject().name("__Directive").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__InputValue)))).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            return directive.getArguments();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("onOperation").type(Scalars.GraphQLBoolean).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("onFragment").type(Scalars.GraphQLBoolean).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("onField").type(Scalars.GraphQLBoolean).build()).build();
    public static GraphQLObjectType __Schema = GraphQLObjectType.newObject().name("__Schema").description("A GraphQL Introspection defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, the entry points for query, mutation, and subscription operations.").field(GraphQLFieldDefinition.newFieldDefinition().name("types").description("A list of all types supported by this server.").type(new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__Type)))).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getAllTypesAsList();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("queryType").description("The type that query operations will be rooted at.").type(new GraphQLNonNull(__Type)).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getQueryType();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("mutationType").description("If this server supports mutation, the type that mutation operations will be rooted at.").type(__Type).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getMutationType();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directives").description("'A list of all directives supported by this server.").type(new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(__Directive)))).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            return environment.getGraphQLSchema().getDirectives();
        }
    }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("subscriptionType").description("'If this server support subscription, the type that subscription operations will be rooted at.").type(__Type).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            return null;
        }
    }).build()).build();
    public static GraphQLFieldDefinition SchemaMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__schema").type(new GraphQLNonNull(__Schema)).description("Access the current type schema of this server.").dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            return environment.getGraphQLSchema();
        }
    }).build();
    public static GraphQLFieldDefinition TypeMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__type").type(__Type).description("Request the type information of a single type.").argument(GraphQLArgument.newArgument().name("name").type(new GraphQLNonNull(Scalars.GraphQLString)).build()).dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            String name = (String)environment.getArgument("name");
            return environment.getGraphQLSchema().getType(name);
        }
    }).build();
    public static GraphQLFieldDefinition TypeNameMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__typename").type(new GraphQLNonNull(Scalars.GraphQLString)).description("The name of the current Object type at runtime.").dataFetcher(new DataFetcher(){

        @Override
        public Object get(DataFetchingEnvironment environment) {
            return environment.getParentType().getName();
        }
    }).build();

    static {
        GraphQLSchema.newSchema().query(GraphQLObjectType.newObject().name("dummySchema").field(SchemaMetaFieldDef).field(TypeMetaFieldDef).field(TypeNameMetaFieldDef).build()).build();
    }

    public static enum TypeKind {
        SCALAR,
        OBJECT,
        INTERFACE,
        UNION,
        ENUM,
        INPUT_OBJECT,
        LIST,
        NON_NULL;

    }
}

