/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Directives;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphQLSchema {
    private final GraphQLObjectType queryType;
    private final GraphQLObjectType mutationType;
    private final Map<String, GraphQLType> typeMap;
    private Set<GraphQLType> dictionary;

    public GraphQLSchema(GraphQLObjectType queryType) {
        this(queryType, null, Collections.emptySet());
    }

    public Set<GraphQLType> getDictionary() {
        return this.dictionary;
    }

    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, Set<GraphQLType> dictionary) {
        Assert.assertNotNull(dictionary, "dictionary can't be null");
        Assert.assertNotNull(queryType, "queryType can't be null");
        this.queryType = queryType;
        this.mutationType = mutationType;
        this.dictionary = dictionary;
        this.typeMap = new SchemaUtil().allTypes(this, dictionary);
    }

    public GraphQLType getType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public List<GraphQLType> getAllTypesAsList() {
        return new ArrayList<GraphQLType>(this.typeMap.values());
    }

    public GraphQLObjectType getQueryType() {
        return this.queryType;
    }

    public GraphQLObjectType getMutationType() {
        return this.mutationType;
    }

    public List<GraphQLDirective> getDirectives() {
        return Arrays.asList(Directives.IncludeDirective, Directives.SkipDirective);
    }

    public GraphQLDirective getDirective(String name) {
        for (GraphQLDirective directive : this.getDirectives()) {
            if (!directive.getName().equals(name)) continue;
            return directive;
        }
        return null;
    }

    public boolean isSupportingMutations() {
        return this.mutationType != null;
    }

    public static Builder newSchema() {
        return new Builder();
    }

    public static class Builder {
        private GraphQLObjectType queryType;
        private GraphQLObjectType mutationType;

        public Builder query(GraphQLObjectType queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder mutation(GraphQLObjectType mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        public GraphQLSchema build() {
            return this.build(Collections.<GraphQLType>emptySet());
        }

        public GraphQLSchema build(Set<GraphQLType> dictionary) {
            Assert.assertNotNull(dictionary, "dictionary can't be null");
            GraphQLSchema graphQLSchema = new GraphQLSchema(this.queryType, this.mutationType, dictionary);
            new SchemaUtil().replaceTypeReferences(graphQLSchema);
            return graphQLSchema;
        }
    }
}

