/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Directives;
import graphql.execution.ExecutionContext;
import graphql.execution.ValuesResolver;
import graphql.language.Directive;
import java.util.List;
import java.util.Map;

public class ConditionalNodes {
    ValuesResolver valuesResolver = new ValuesResolver();

    public boolean shouldInclude(ExecutionContext executionContext, List<Directive> directives) {
        Directive skipDirective = this.findDirective(directives, Directives.SkipDirective.getName());
        if (skipDirective != null) {
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(Directives.SkipDirective.getArguments(), skipDirective.getArguments(), executionContext.getVariables());
            return (Boolean)argumentValues.get("if") == false;
        }
        Directive includeDirective = this.findDirective(directives, Directives.IncludeDirective.getName());
        if (includeDirective != null) {
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(Directives.IncludeDirective.getArguments(), includeDirective.getArguments(), executionContext.getVariables());
            return (Boolean)argumentValues.get("if");
        }
        return true;
    }

    private Directive findDirective(List<Directive> directives, String name) {
        for (Directive directive : directives) {
            if (!directive.getName().equals(name)) continue;
            return directive;
        }
        return null;
    }
}

