/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GraphQLObjectType
implements GraphQLType,
GraphQLOutputType,
GraphQLFieldsContainer,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private final List<GraphQLInterfaceType> interfaces = new ArrayList<GraphQLInterfaceType>();

    public GraphQLObjectType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, List<GraphQLInterfaceType> interfaces) {
        Assert.assertNotNull(name, "name can't null");
        Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't null");
        Assert.assertNotNull(interfaces, "interfaces can't null");
        this.name = name;
        this.description = description;
        this.interfaces.addAll(interfaces);
        this.buildDefinitionMap(fieldDefinitions);
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            this.fieldDefinitionsByName.put(fieldDefinition.getName(), fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return new ArrayList<GraphQLFieldDefinition>(this.fieldDefinitionsByName.values());
    }

    public List<GraphQLInterfaceType> getInterfaces() {
        return new ArrayList<GraphQLInterfaceType>(this.interfaces);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "GraphQLObjectType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName + ", interfaces=" + this.interfaces + '}';
    }

    public static Builder newObject() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private List<GraphQLFieldDefinition> fieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        private List<GraphQLInterfaceType> interfaces = new ArrayList<GraphQLInterfaceType>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, "fieldDefinition can't be null");
            this.fieldDefinitions.add(fieldDefinition);
            return this;
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, "fieldDefinitions can't be null");
            this.fieldDefinitions.addAll(fieldDefinitions);
            return this;
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, "interfaceType can't be null");
            this.interfaces.add(interfaceType);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public GraphQLObjectType build() {
            return new GraphQLObjectType(this.name, this.description, this.fieldDefinitions, this.interfaces);
        }
    }
}

