/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.relay.Base64;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;

public class SimpleListConnection
implements DataFetcher {
    private static final String DUMMY_CURSOR_PREFIX = "simple-cursor";
    private List<?> data = new ArrayList();

    public SimpleListConnection(List<?> data) {
        this.data = data;
    }

    private List<Edge> buildEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int ix = 0;
        for (Object object : this.data) {
            edges.add(new Edge(object, new ConnectionCursor(this.createCursor(ix++))));
        }
        return edges;
    }

    @Override
    public Object get(DataFetchingEnvironment environment) {
        int beforeOffset;
        int end;
        List<Edge> edges = this.buildEdges();
        int afterOffset = this.getOffsetFromCursor((String)environment.getArgument("after"), -1);
        int begin = Math.max(afterOffset, -1) + 1;
        if ((edges = edges.subList(begin, end = Math.min(beforeOffset = this.getOffsetFromCursor((String)environment.getArgument("before"), edges.size()), edges.size()))).size() == 0) {
            return this.emptyConnection();
        }
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        ConnectionCursor firstPresliceCursor = edges.get((int)0).cursor;
        ConnectionCursor lastPresliceCursor = edges.get((int)(edges.size() - 1)).cursor;
        if (first != null) {
            edges = edges.subList(0, first <= edges.size() ? first.intValue() : edges.size());
        }
        if (last != null) {
            edges = edges.subList(edges.size() - last, edges.size());
        }
        if (edges.size() == 0) {
            return this.emptyConnection();
        }
        Edge firstEdge = edges.get(0);
        Edge lastEdge = edges.get(edges.size() - 1);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setStartCursor(firstEdge.getCursor());
        pageInfo.setEndCursor(lastEdge.getCursor());
        pageInfo.setHasPreviousPage(!firstEdge.getCursor().equals(firstPresliceCursor));
        pageInfo.setHasNextPage(!lastEdge.getCursor().equals(lastPresliceCursor));
        Connection connection = new Connection();
        connection.setEdges(edges);
        connection.setPageInfo(pageInfo);
        return connection;
    }

    private Connection emptyConnection() {
        Connection connection = new Connection();
        connection.setPageInfo(new PageInfo());
        return connection;
    }

    public ConnectionCursor cursorForObjectInConnection(Object object) {
        int index = this.data.indexOf(object);
        String cursor = this.createCursor(index);
        return new ConnectionCursor(cursor);
    }

    private int getOffsetFromCursor(String cursor, int defaultValue) {
        if (cursor == null) {
            return defaultValue;
        }
        String string = Base64.fromBase64(cursor);
        return Integer.parseInt(string.substring(DUMMY_CURSOR_PREFIX.length()));
    }

    private String createCursor(int offset) {
        String string = Base64.toBase64(DUMMY_CURSOR_PREFIX + Integer.toString(offset));
        return string;
    }
}

