/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.GraphQLException;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaUtil {
    public boolean isLeafType(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = this.getUnmodifiedType(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType;
    }

    public boolean isInputType(GraphQLType graphQLType) {
        GraphQLUnmodifiedType unmodifiedType = this.getUnmodifiedType(graphQLType);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType || unmodifiedType instanceof GraphQLInputObjectType;
    }

    public GraphQLUnmodifiedType getUnmodifiedType(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLModifiedType) {
            return this.getUnmodifiedType(((GraphQLModifiedType)graphQLType).getWrappedType());
        }
        return (GraphQLUnmodifiedType)graphQLType;
    }

    private void collectTypes(GraphQLType root, Map<String, GraphQLType> result) {
        if (root instanceof GraphQLNonNull) {
            this.collectTypes(((GraphQLNonNull)root).getWrappedType(), result);
        } else if (root instanceof GraphQLList) {
            this.collectTypes(((GraphQLList)root).getWrappedType(), result);
        } else if (root instanceof GraphQLEnumType) {
            result.put(((GraphQLEnumType)root).getName(), root);
        } else if (root instanceof GraphQLScalarType) {
            result.put(((GraphQLScalarType)root).getName(), root);
        } else if (root instanceof GraphQLObjectType) {
            this.collectTypesForObjects((GraphQLObjectType)root, result);
        } else if (root instanceof GraphQLInterfaceType) {
            this.collectTypesForInterfaces((GraphQLInterfaceType)root, result);
        } else if (root instanceof GraphQLUnionType) {
            this.collectTypesForUnions((GraphQLUnionType)root, result);
        } else if (root instanceof GraphQLInputObjectType) {
            this.collectTypesForInputObjects((GraphQLInputObjectType)root, result);
        } else if (!(root instanceof GraphQLTypeReference)) {
            throw new RuntimeException("Unknown type " + root);
        }
    }

    private void collectTypesForUnions(GraphQLUnionType unionType, Map<String, GraphQLType> result) {
        result.put(unionType.getName(), unionType);
        for (GraphQLType graphQLType : unionType.getTypes()) {
            this.collectTypes(graphQLType, result);
        }
    }

    private void collectTypesForInterfaces(GraphQLInterfaceType interfaceType, Map<String, GraphQLType> result) {
        if (result.containsKey(interfaceType.getName())) {
            return;
        }
        result.put(interfaceType.getName(), interfaceType);
        for (GraphQLFieldDefinition fieldDefinition : interfaceType.getFieldDefinitions()) {
            this.collectTypes(fieldDefinition.getType(), result);
            for (GraphQLArgument fieldArgument : fieldDefinition.getArguments()) {
                this.collectTypes(fieldArgument.getType(), result);
            }
        }
    }

    private void collectTypesForObjects(GraphQLObjectType objectType, Map<String, GraphQLType> result) {
        if (result.containsKey(objectType.getName())) {
            return;
        }
        result.put(objectType.getName(), objectType);
        for (GraphQLFieldDefinition fieldDefinition : objectType.getFieldDefinitions()) {
            this.collectTypes(fieldDefinition.getType(), result);
            for (GraphQLArgument fieldArgument : fieldDefinition.getArguments()) {
                this.collectTypes(fieldArgument.getType(), result);
            }
        }
        for (GraphQLInterfaceType interfaceType : objectType.getInterfaces()) {
            this.collectTypes(interfaceType, result);
        }
    }

    private void collectTypesForInputObjects(GraphQLInputObjectType objectType, Map<String, GraphQLType> result) {
        if (result.containsKey(objectType.getName())) {
            return;
        }
        result.put(objectType.getName(), objectType);
        for (GraphQLInputObjectField fieldDefinition : objectType.getFields()) {
            this.collectTypes(fieldDefinition.getType(), result);
        }
    }

    public Map<String, GraphQLType> allTypes(GraphQLSchema schema, Set<GraphQLType> dictionary) {
        LinkedHashMap<String, GraphQLType> typesByName = new LinkedHashMap<String, GraphQLType>();
        this.collectTypes(schema.getQueryType(), typesByName);
        if (schema.isSupportingMutations()) {
            this.collectTypes(schema.getMutationType(), typesByName);
        }
        if (dictionary != null) {
            for (GraphQLType type : dictionary) {
                this.collectTypes(type, typesByName);
            }
        }
        this.collectTypes(Introspection.__Schema, typesByName);
        return typesByName;
    }

    public List<GraphQLObjectType> findImplementations(GraphQLSchema schema, GraphQLInterfaceType interfaceType) {
        Map<String, GraphQLType> allTypes = this.allTypes(schema, schema.getDictionary());
        ArrayList<GraphQLObjectType> result = new ArrayList<GraphQLObjectType>();
        for (GraphQLType type : allTypes.values()) {
            GraphQLObjectType objectType;
            if (!(type instanceof GraphQLObjectType) || !(objectType = (GraphQLObjectType)type).getInterfaces().contains(interfaceType)) continue;
            result.add(objectType);
        }
        return result;
    }

    void replaceTypeReferences(GraphQLSchema schema) {
        Map<String, GraphQLType> typeMap = this.allTypes(schema, schema.getDictionary());
        for (GraphQLType type : typeMap.values()) {
            if (!(type instanceof GraphQLFieldsContainer)) continue;
            this.resolveTypeReferencesForFieldsContainer((GraphQLFieldsContainer)type, typeMap);
        }
    }

    private void resolveTypeReferencesForFieldsContainer(GraphQLFieldsContainer fieldsContainer, Map<String, GraphQLType> typeMap) {
        for (GraphQLFieldDefinition fieldDefinition : fieldsContainer.getFieldDefinitions()) {
            fieldDefinition.replaceTypeReferences(typeMap);
        }
    }

    GraphQLType resolveTypeReference(GraphQLType type, Map<String, GraphQLType> typeMap) {
        if (type instanceof GraphQLTypeReference || typeMap.containsKey(type.getName())) {
            GraphQLType resolvedType = typeMap.get(type.getName());
            if (resolvedType == null) {
                throw new GraphQLException("type " + type.getName() + " not found in schema");
            }
            return resolvedType;
        }
        if (type instanceof GraphQLList) {
            ((GraphQLList)type).replaceTypeReferences(typeMap);
        }
        if (type instanceof GraphQLNonNull) {
            ((GraphQLNonNull)type).replaceTypeReferences(typeMap);
        }
        return type;
    }

    List<GraphQLType> resolveTypeReferences(List<GraphQLType> types, Map<String, GraphQLType> typeMap) {
        ArrayList<GraphQLType> resolvedTypes = new ArrayList<GraphQLType>();
        for (GraphQLType type : types) {
            resolvedTypes.add(this.resolveTypeReference(type, typeMap));
        }
        return resolvedTypes;
    }
}

