/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLDirective;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.List;

public class KnownDirectives
extends AbstractRule {
    public KnownDirectives(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        GraphQLDirective graphQLDirective = this.getValidationContext().getSchema().getDirective(directive.getName());
        if (graphQLDirective == null) {
            String message = String.format("Unknown directive %s", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.UnknownDirective, directive.getSourceLocation(), message));
            return;
        }
        Node ancestor = ancestors.get(ancestors.size() - 1);
        if (this.hasInvalidLocation(graphQLDirective, ancestor)) {
            String message = String.format("Directive %s not allowed here", directive.getName());
            this.addError(new ValidationError(ValidationErrorType.MisplacedDirective, directive.getSourceLocation(), message));
        }
    }

    private boolean hasInvalidLocation(GraphQLDirective directive, Node ancestor) {
        if (ancestor instanceof OperationDefinition) {
            OperationDefinition.Operation operation = ((OperationDefinition)ancestor).getOperation();
            return OperationDefinition.Operation.QUERY.equals((Object)operation) ? !directive.validLocations().contains((Object)Introspection.DirectiveLocation.QUERY) && !directive.isOnOperation() : !directive.validLocations().contains((Object)Introspection.DirectiveLocation.MUTATION) && !directive.isOnOperation();
        }
        if (ancestor instanceof Field) {
            return !directive.validLocations().contains((Object)Introspection.DirectiveLocation.FIELD) && !directive.isOnField();
        }
        if (ancestor instanceof FragmentSpread) {
            return !directive.validLocations().contains((Object)Introspection.DirectiveLocation.FRAGMENT_SPREAD) && !directive.isOnFragment();
        }
        if (ancestor instanceof FragmentDefinition) {
            return !directive.validLocations().contains((Object)Introspection.DirectiveLocation.FRAGMENT_DEFINITION) && !directive.isOnFragment();
        }
        if (ancestor instanceof InlineFragment) {
            return !directive.validLocations().contains((Object)Introspection.DirectiveLocation.INLINE_FRAGMENT) || directive.isOnFragment();
        }
        return true;
    }
}

