/*
 * Decompiled with CFR 0.152.
 */
package com.lambeta;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Chars;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnderscoreString {
    private static final Pattern BEFORE_UPPER_CASE = Pattern.compile("(?=\\p{Upper})");

    public static String capitalize(String word) {
        return UnderscoreString.onCapitalize(word, true);
    }

    private static String onCapitalize(String word, boolean on) {
        String trimWord = word.trim();
        return trimWord.isEmpty() ? trimWord : new StringBuilder(trimWord.length()).append(on ? Ascii.toUpperCase((char)trimWord.charAt(0)) : Ascii.toLowerCase((char)trimWord.charAt(0))).append(trimWord.substring(1)).toString();
    }

    public static String slugify(String s) {
        String s1 = CharMatcher.JAVA_LETTER.negate().removeFrom((CharSequence)s);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, s1);
    }

    public static String trim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimFrom((CharSequence)word);
    }

    public static String trim(String word) {
        return CharMatcher.WHITESPACE.trimFrom((CharSequence)word);
    }

    public static String ltrim(String word) {
        return CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)word);
    }

    public static String ltrim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimLeadingFrom((CharSequence)word);
    }

    public static String rtrim(String word) {
        return CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)word);
    }

    public static String rtrim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimTrailingFrom((CharSequence)word);
    }

    public static String repeat(String word) {
        return UnderscoreString.repeat(word, 0);
    }

    public static String repeat(String word, int count) {
        return Strings.repeat((String)word, (int)count);
    }

    public static <T> String repeat(String word, int count, T insert) {
        String repeat = UnderscoreString.repeat(word + insert, count);
        return repeat.substring(0, repeat.length() - insert.toString().length());
    }

    public static String decapitalize(String word) {
        return UnderscoreString.onCapitalize(word, false);
    }

    public static String join(String ... args) {
        return Joiner.on((String)"").skipNulls().join((Object[])args);
    }

    public static String reverse(String word) {
        return new StringBuilder(word).reverse().toString();
    }

    public static String clean(String word) {
        return CharMatcher.WHITESPACE.collapseFrom((CharSequence)UnderscoreString.trim(word), ' ');
    }

    public static String[] chop(String word, int fixedLength) {
        Preconditions.checkArgument((fixedLength >= 0 ? 1 : 0) != 0, (Object)"fixedLength must greater than or equal to zero");
        if (fixedLength == 0) {
            return new String[]{word};
        }
        return (String[])Iterables.toArray((Iterable)Splitter.fixedLength((int)fixedLength).split((CharSequence)word), String.class);
    }

    public static String splice(String word, int start, int length, String replacement) {
        return new StringBuilder(word).replace(start, start + length, replacement).toString();
    }

    public static char pred(char ch) {
        return (char)(ch - '\u0001');
    }

    public static char succ(char ch) {
        return (char)(ch + '\u0001');
    }

    public static String titleize(String sentence) {
        String trimedSentence = UnderscoreString.trim(sentence);
        StringBuilder sb = new StringBuilder();
        int length = trimedSentence.length();
        boolean capitalizeNext = true;
        for (int i = 0; i < length; ++i) {
            char c = trimedSentence.charAt(i);
            if (CharMatcher.anyOf((CharSequence)"_- ").matches(c)) {
                sb.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                sb.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String camelize(String sentence) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, CharMatcher.anyOf((CharSequence)"- ").collapseFrom((CharSequence)UnderscoreString.trim(sentence), '_'));
    }

    public static String dasherize(String sentence) {
        String to = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, CharMatcher.WHITESPACE.collapseFrom((CharSequence)UnderscoreString.trim(UnderscoreString.upperBy_(sentence)), '-'));
        return UnderscoreString.cleanBy(to, '-');
    }

    public static String underscored(String sentence) {
        String to = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, CharMatcher.anyOf((CharSequence)"- ").collapseFrom((CharSequence)UnderscoreString.upperBy_(UnderscoreString.trim(sentence)), '_'));
        return UnderscoreString.cleanBy(to, '_');
    }

    public static String classify(String sentence) {
        return UnderscoreString.capitalize(UnderscoreString.camelize(sentence));
    }

    public static String humanize(String sentence) {
        return UnderscoreString.capitalize(UnderscoreString.replace(UnderscoreString.underscored(sentence), '_', ' '));
    }

    public static String surround(String word, String wrap) {
        return String.format("%s%s%s", wrap, word, wrap);
    }

    public static String quote(String word) {
        return UnderscoreString.surround(word, "\"");
    }

    public static String unquote(String word) {
        return UnderscoreString.unquote(word, '\"');
    }

    public static String unquote(String word, char match) {
        if (word.charAt(0) == match && word.charAt(word.length() - 1) == match) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    public static String numberFormat(double number) {
        return UnderscoreString.numberFormat(number, 0);
    }

    public static String numberFormat(double number, int scale) {
        return NumberFormat.getInstance().format(new BigDecimal(number).setScale(scale, 3));
    }

    public static String strRight(String sentence, String separator) {
        return sentence.substring(sentence.indexOf(separator) + separator.length());
    }

    public static String strRightBack(String sentence, String separator) {
        if (Strings.isNullOrEmpty((String)separator)) {
            return sentence;
        }
        return sentence.substring(sentence.lastIndexOf(separator) + separator.length());
    }

    public static String strLeft(String sentence, String separator) {
        if (Strings.isNullOrEmpty((String)separator)) {
            return sentence;
        }
        return UnderscoreString.strLeftFrom(sentence, sentence.indexOf(separator));
    }

    public static String strLeftBack(String sentence, String separator) {
        return UnderscoreString.strLeftFrom(sentence, sentence.lastIndexOf(separator));
    }

    private static String strLeftFrom(String sentence, int index) {
        return index != -1 ? sentence.substring(0, index) : sentence;
    }

    private static String cleanBy(String to, char underscore) {
        return CharMatcher.anyOf((CharSequence)String.valueOf(underscore)).collapseFrom((CharSequence)to, underscore);
    }

    private static String replace(String sentence, char from, char to) {
        return CharMatcher.anyOf((CharSequence)String.valueOf(from)).replaceFrom((CharSequence)sentence, to);
    }

    private static String upperBy_(String sentence) {
        return Joiner.on((char)'_').join(Splitter.on((Pattern)BEFORE_UPPER_CASE).split((CharSequence)sentence));
    }

    public static String toSentence(String[] strings) {
        Preconditions.checkNotNull((Object)strings, (Object)"words should not be null");
        String lastOne = strings[strings.length - 1];
        strings[strings.length - 1] = null;
        return Joiner.on((String)", ").skipNulls().join((Object[])strings) + " and " + lastOne;
    }

    public static int count(String sentence, String find) {
        int nonReplacedLength = sentence.length();
        int length = sentence.replace(find, "").length();
        return (nonReplacedLength - length) / find.length();
    }

    public static String truncate(String sentence, int position, String pad) {
        Preconditions.checkState((sentence.length() >= position ? 1 : 0) != 0);
        return UnderscoreString.splice(sentence, position, sentence.length() - position + 1, pad);
    }

    public static String lpad(String sentence, int count) {
        return UnderscoreString.lpad(sentence, count, ' ');
    }

    public static String lpad(String sentence, int count, char ch) {
        return Strings.padStart((String)sentence, (int)count, (char)ch);
    }

    public static String rpad(String sentence, int count) {
        return UnderscoreString.rpad(sentence, count, ' ');
    }

    public static String rpad(String sentence, int count, char ch) {
        return Strings.padEnd((String)sentence, (int)count, (char)ch);
    }

    public static String lrpad(String sentence, int count) {
        return UnderscoreString.lrpad(sentence, count, ' ');
    }

    public static String lrpad(String sentence, int count, char ch) {
        int padEnd = (count - sentence.length()) / 2;
        return UnderscoreString.rpad(UnderscoreString.lpad(sentence, count - padEnd, ch), count, ch);
    }

    public static String[] words(String sentence) {
        return (String[])Iterables.toArray((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).split((CharSequence)CharMatcher.anyOf((CharSequence)" _-").collapseFrom((CharSequence)sentence, ' ')), String.class);
    }

    public static String prune(String sentence, int count) {
        if (sentence.length() <= count) {
            return sentence;
        }
        String[] words = UnderscoreString.words(sentence);
        if (words.length == 1) {
            return sentence;
        }
        int rest = count;
        for (int i = 0; i < words.length; ++i) {
            int n = rest = i == 0 ? rest - words[i].length() : rest - words[i].length() - 1;
            if (rest >= 0) continue;
            if (i == 0) {
                return UnderscoreString.rtrim(words[i], ",") + "...";
            }
            words[i - 1] = UnderscoreString.rtrim(words[i - 1], ",") + "...";
            Object[] target = new String[i];
            System.arraycopy(words, 0, target, 0, i);
            return Joiner.on((char)' ').join(target);
        }
        return sentence;
    }

    public static boolean isBlank(String s) {
        return Strings.isNullOrEmpty((String)s) || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)s);
    }

    public static String replaceAll(String str, String find, String replace) {
        return UnderscoreString.replaceAll(str, find, replace, false);
    }

    public static String replaceAll(String str, String find, String replace, boolean ignorecase) {
        String findRegex = ignorecase ? "(?i)" + find : find;
        return Pattern.compile(findRegex).matcher(Strings.nullToEmpty((String)str)).replaceAll(replace);
    }

    public static String swapCase(String str) {
        List chars = Chars.asList((char[])Strings.nullToEmpty((String)str).toCharArray());
        return FluentIterable.from((Iterable)chars).transform(UnderscoreString.flip()).join(Joiner.on((String)""));
    }

    private static Function<Character, Character> flip() {
        return new Function<Character, Character>(){

            public Character apply(Character ch) {
                return Character.valueOf(Character.isUpperCase(ch.charValue()) ? Character.toLowerCase(ch.charValue()) : Character.toUpperCase(ch.charValue()));
            }
        };
    }

    public static int naturalCmp(String str0, String str1) {
        if (str0 == null) {
            return -1;
        }
        if (str1 == null) {
            return 1;
        }
        if (str0.equals(str1)) {
            return 0;
        }
        Pattern numberRegex = Pattern.compile("(\\.\\d+|\\d+|\\D+)");
        String[] token0 = UnderscoreString.reseq(numberRegex.matcher(str0));
        String[] token1 = UnderscoreString.reseq(numberRegex.matcher(str1));
        int minSize = Math.min(token0.length, token1.length);
        for (int i = 0; i < minSize; ++i) {
            String a = token0[i];
            String b = token1[i];
            if (a.equals(b)) continue;
            try {
                double num0 = Double.parseDouble(a);
                double num1 = Double.parseDouble(b);
                return num0 > num1 ? 1 : -1;
            }
            catch (NumberFormatException e) {
                return a.compareTo(b) > 0 ? 1 : -1;
            }
        }
        if (token0.length != token1.length) {
            return token0.length > token1.length ? 1 : -1;
        }
        return str0.compareTo(str1) > 0 ? 1 : -1;
    }

    private static String[] reseq(Matcher matcher) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String dedent(String str0) {
        String str = Strings.nullToEmpty((String)str0);
        return Pattern.compile(String.format("^[ \\t]{%d}", UnderscoreString.indent(str)), 8).matcher(str).replaceAll("");
    }

    private static int indent(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return 0;
        }
        String[] reseq = UnderscoreString.reseq(Pattern.compile("^[\\s\\t]*", 8).matcher(str));
        int indent = reseq[0].length();
        for (int i = 1; i < reseq.length; ++i) {
            indent = Math.min(reseq[i].length(), indent);
        }
        return indent;
    }

    private static String trailingSpaces(String word, int width) {
        int gap = width - word.length();
        return gap > 0 ? UnderscoreString.repeat(" ", gap) : "";
    }

    private static Function<String, String> trailingSpaces(final int width) {
        return new Function<String, String>(){

            public String apply(String word) {
                return word + UnderscoreString.trailingSpaces(word, width);
            }
        };
    }
}

