/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.LexUtility;
import java.util.ArrayList;

public class CommandAnalyzerMethod
extends AbstractCommandAnalyzer {
    public CommandAnalyzerMethod(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        String alias;
        String methodName = ExpressionUtility.convertToString(this.analyzeExpression());
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "from", "Keyword 'FROM' is missing in command 'METHOD'");
        String className = ExpressionUtility.convertToString(this.analyzeExpression());
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "is", "Keyword 'IS' is missing in command 'METHOD'");
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "(", "'(' is missing in command 'METHOD' after the keyword 'IS'");
        ExpressionList argExpressions = (ExpressionList)this.ctx.expressionListAnalyzer.analyze();
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, ")", "')' is missing in command 'METHOD'");
        if (LexUtility.isLexeme(this.ctx.lexicalAnalyzer, "use")) {
            LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "as", "Keyword 'AS' is missung after 'USE in command 'METHOD'");
            alias = ExpressionUtility.convertToString(this.analyzeExpression());
        } else {
            alias = methodName;
        }
        ArrayList argClasses = new ArrayList();
        for (Expression expression : argExpressions) {
            String argClassName = ExpressionUtility.convertToString(expression);
            argClasses.add(KlassUtility.forNameEx(argClassName));
        }
        CommandMethod node = new CommandMethod();
        node.setArgumentTypes(argClasses.toArray(new Class[0]));
        node.setKlass(KlassUtility.forNameEx(className));
        node.setMethodName(methodName);
        node.setAlias(alias);
        this.consumeEndOfLine();
        return node;
    }
}

