/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.lang;

import com.stackify.api.ErrorItem;
import com.stackify.api.TraceFrame;
import com.stackify.api.common.lang.StackTraceElements;
import java.util.ArrayList;
import java.util.List;

public class Throwables {
    public static List<Throwable> getCausalChain(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Throwable is null");
        }
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        causes.add(throwable);
        for (Throwable cause = throwable.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
            causes.add(cause);
        }
        return causes;
    }

    public static ErrorItem toErrorItem(Throwable t) {
        List<Throwable> throwables = Throwables.getCausalChain(t);
        ArrayList<ErrorItem.Builder> builders = new ArrayList<ErrorItem.Builder>(throwables.size());
        for (Throwable throwable : throwables) {
            ErrorItem.Builder builder = Throwables.toErrorItemBuilderWithoutCause(throwable);
            builders.add(builder);
        }
        for (int i = builders.size() - 1; 0 < i; --i) {
            ErrorItem.Builder parent = (ErrorItem.Builder)builders.get(i - 1);
            ErrorItem.Builder child = (ErrorItem.Builder)builders.get(i);
            parent.innerError(child.build());
        }
        return ((ErrorItem.Builder)builders.get(0)).build();
    }

    private static ErrorItem.Builder toErrorItemBuilderWithoutCause(Throwable t) {
        ErrorItem.Builder builder = ErrorItem.newBuilder();
        builder.message(t.getMessage());
        builder.errorType(t.getClass().getCanonicalName());
        ArrayList<TraceFrame> stackFrames = new ArrayList<TraceFrame>();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null && 0 < stackTrace.length) {
            StackTraceElement firstFrame = stackTrace[0];
            builder.sourceMethod(firstFrame.getClassName() + "." + firstFrame.getMethodName());
            for (int i = 0; i < stackTrace.length; ++i) {
                TraceFrame stackFrame = StackTraceElements.toTraceFrame(stackTrace[i]);
                stackFrames.add(stackFrame);
            }
        }
        builder.stackTrace(stackFrames);
        return builder;
    }

    private Throwables() {
    }
}

