/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.stackify.api.common.http.HttpException;
import java.util.concurrent.TimeUnit;

public class LogBackgroundServiceScheduler
extends AbstractScheduledService.CustomScheduler {
    private static final long ONE_SECOND = 1000L;
    private static final long FIVE_SECONDS = 5000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long FIVE_MINUTES = 300000L;
    private long scheduleDelay = 1000L;
    private long lastHttpError = 0L;

    public void update(int numSent) {
        this.lastHttpError = 0L;
        if (100 <= numSent) {
            this.scheduleDelay = Math.max(Math.round((double)this.scheduleDelay / 2.0), 1000L);
        } else if (numSent < 10) {
            this.scheduleDelay = Math.min(Math.round(1.25 * (double)this.scheduleDelay), 5000L);
        }
    }

    public void update(Throwable t) {
        HttpException httpException;
        boolean isAuthorized = true;
        if (t instanceof HttpException && (httpException = (HttpException)t).getStatusCode() == 401) {
            isAuthorized = false;
        }
        if (isAuthorized) {
            if (this.lastHttpError == 0L) {
                this.lastHttpError = System.currentTimeMillis();
            }
            long sinceFirstError = System.currentTimeMillis() - this.lastHttpError;
            this.scheduleDelay = Math.min(Math.max(sinceFirstError, 1000L), 60000L);
        } else {
            this.lastHttpError = System.currentTimeMillis();
            this.scheduleDelay = 300000L;
        }
    }

    public long getScheduleDelay() {
        return this.scheduleDelay;
    }

    public long getLastHttpError() {
        return this.lastHttpError;
    }

    protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() {
        return new AbstractScheduledService.CustomScheduler.Schedule(this.scheduleDelay, TimeUnit.MILLISECONDS);
    }
}

