/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class AppIdentity {
    @JsonProperty(value="DeviceID")
    private final Integer deviceId;
    @JsonProperty(value="DeviceAppID")
    private final Integer deviceAppId;
    @JsonProperty(value="AppNameID")
    private final String appNameId;
    @JsonProperty(value="EnvID")
    private final Integer envId;
    @JsonProperty(value="AppName")
    private final String appName;
    @JsonProperty(value="AppEnvID")
    private final String appEnvId;
    @JsonProperty(value="DeviceAlias")
    private final String deviceAlias;

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public Integer getDeviceAppId() {
        return this.deviceAppId;
    }

    public String getAppNameId() {
        return this.appNameId;
    }

    public Integer getEnvId() {
        return this.envId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppEnvId() {
        return this.appEnvId;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    private AppIdentity(Builder builder) {
        this.deviceId = builder.deviceId;
        this.deviceAppId = builder.deviceAppId;
        this.appNameId = builder.appNameId;
        this.envId = builder.envId;
        this.appName = builder.appName;
        this.appEnvId = builder.appEnvId;
        this.deviceAlias = builder.deviceAlias;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "AppIdentity{deviceId=" + this.deviceId + ", deviceAppId=" + this.deviceAppId + ", appNameId=" + this.appNameId + ", envId=" + this.envId + ", appName=" + this.appName + ", appEnvId=" + this.appEnvId + ", deviceAlias=" + this.deviceAlias + "}";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        @JsonProperty(value="DeviceID")
        private Integer deviceId;
        @JsonProperty(value="DeviceAppID")
        private Integer deviceAppId;
        @JsonProperty(value="AppNameID")
        private String appNameId;
        @JsonProperty(value="EnvID")
        private Integer envId;
        @JsonProperty(value="AppName")
        private String appName;
        @JsonProperty(value="AppEnvID")
        private String appEnvId;
        @JsonProperty(value="DeviceAlias")
        private String deviceAlias;

        public Builder deviceId(Integer deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceAppId(Integer deviceAppId) {
            this.deviceAppId = deviceAppId;
            return this;
        }

        public Builder appNameId(String appNameId) {
            this.appNameId = appNameId;
            return this;
        }

        public Builder envId(Integer envId) {
            this.envId = envId;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder appEnvId(String appEnvId) {
            this.appEnvId = appEnvId;
            return this;
        }

        public Builder deviceAlias(String deviceAlias) {
            this.deviceAlias = deviceAlias;
            return this;
        }

        public AppIdentity build() {
            return new AppIdentity(this);
        }
    }
}

