/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class TraceFrame {
    @JsonProperty(value="CodeFileName")
    private final String codeFileName;
    @JsonProperty(value="LineNum")
    private final Integer lineNum;
    @JsonProperty(value="Method")
    private final String method;

    public String getCodeFileName() {
        return this.codeFileName;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }

    public String getMethod() {
        return this.method;
    }

    public Builder toBuilder() {
        return TraceFrame.newBuilder().codeFileName(this.codeFileName).lineNum(this.lineNum).method(this.method);
    }

    private TraceFrame(Builder builder) {
        this.codeFileName = builder.codeFileName;
        this.lineNum = builder.lineNum;
        this.method = builder.method;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        @JsonProperty(value="CodeFileName")
        private String codeFileName;
        @JsonProperty(value="LineNum")
        private Integer lineNum;
        @JsonProperty(value="Method")
        private String method;

        public Builder codeFileName(String codeFileName) {
            this.codeFileName = codeFileName;
            return this;
        }

        public Builder lineNum(Integer lineNum) {
            this.lineNum = lineNum;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public TraceFrame build() {
            return new TraceFrame(this);
        }
    }
}

