/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Answer;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class Questionnaire {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="answers")
    private JsonNullable<? extends List<Answer>> answers;

    @JsonCreator
    public Questionnaire(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="answers") JsonNullable<? extends List<Answer>> answers) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(answers, "answers");
        this.id = id;
        this.remoteId = remoteId;
        this.answers = answers;
    }

    public Questionnaire() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends List<Answer>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<List<Answer>> answers() {
        return this.answers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Questionnaire withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Questionnaire withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Questionnaire withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public Questionnaire withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Questionnaire withAnswers(List<Answer> answers) {
        Utils.checkNotNull(answers, "answers");
        this.answers = JsonNullable.of(answers);
        return this;
    }

    public Questionnaire withAnswers(JsonNullable<? extends List<Answer>> answers) {
        Utils.checkNotNull(answers, "answers");
        this.answers = answers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Questionnaire other = (Questionnaire)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.answers, other.answers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.answers);
    }

    public String toString() {
        return Utils.toString(Questionnaire.class, "id", this.id, "remoteId", this.remoteId, "answers", this.answers);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<? extends List<Answer>> answers = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder answers(List<Answer> answers) {
            Utils.checkNotNull(answers, "answers");
            this.answers = JsonNullable.of(answers);
            return this;
        }

        public Builder answers(JsonNullable<? extends List<Answer>> answers) {
            Utils.checkNotNull(answers, "answers");
            this.answers = answers;
            return this;
        }

        public Questionnaire build() {
            return new Questionnaire(this.id, this.remoteId, this.answers);
        }
    }
}

