/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class CreateHRISBenefitValue {
    public static final CreateHRISBenefitValue RETIREMENT_SAVINGS = new CreateHRISBenefitValue("retirement_savings");
    public static final CreateHRISBenefitValue HEALTH_SAVINGS = new CreateHRISBenefitValue("health_savings");
    public static final CreateHRISBenefitValue OTHER = new CreateHRISBenefitValue("other");
    public static final CreateHRISBenefitValue HEALTH_INSURANCE = new CreateHRISBenefitValue("health_insurance");
    public static final CreateHRISBenefitValue INSURANCE = new CreateHRISBenefitValue("insurance");
    public static final CreateHRISBenefitValue UNMAPPED_VALUE = new CreateHRISBenefitValue("unmapped_value");
    private static final Map<String, CreateHRISBenefitValue> values = CreateHRISBenefitValue.createValuesMap();
    private static final Map<String, CreateHRISBenefitValueEnum> enums = CreateHRISBenefitValue.createEnumsMap();
    private final String value;

    private CreateHRISBenefitValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateHRISBenefitValue of(String value) {
        Class<CreateHRISBenefitValue> clazz = CreateHRISBenefitValue.class;
        synchronized (CreateHRISBenefitValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CreateHRISBenefitValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<CreateHRISBenefitValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateHRISBenefitValue other = (CreateHRISBenefitValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CreateHRISBenefitValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateHRISBenefitValue[] values() {
        Class<CreateHRISBenefitValue> clazz = CreateHRISBenefitValue.class;
        synchronized (CreateHRISBenefitValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CreateHRISBenefitValue[0]);
        }
    }

    private static final Map<String, CreateHRISBenefitValue> createValuesMap() {
        LinkedHashMap<String, CreateHRISBenefitValue> map = new LinkedHashMap<String, CreateHRISBenefitValue>();
        map.put("retirement_savings", RETIREMENT_SAVINGS);
        map.put("health_savings", HEALTH_SAVINGS);
        map.put("other", OTHER);
        map.put("health_insurance", HEALTH_INSURANCE);
        map.put("insurance", INSURANCE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateHRISBenefitValueEnum> createEnumsMap() {
        HashMap<String, CreateHRISBenefitValueEnum> map = new HashMap<String, CreateHRISBenefitValueEnum>();
        map.put("retirement_savings", CreateHRISBenefitValueEnum.RETIREMENT_SAVINGS);
        map.put("health_savings", CreateHRISBenefitValueEnum.HEALTH_SAVINGS);
        map.put("other", CreateHRISBenefitValueEnum.OTHER);
        map.put("health_insurance", CreateHRISBenefitValueEnum.HEALTH_INSURANCE);
        map.put("insurance", CreateHRISBenefitValueEnum.INSURANCE);
        map.put("unmapped_value", CreateHRISBenefitValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CreateHRISBenefitValueEnum {
        RETIREMENT_SAVINGS("retirement_savings"),
        HEALTH_SAVINGS("health_savings"),
        OTHER("other"),
        HEALTH_INSURANCE("health_insurance"),
        INSURANCE("insurance"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CreateHRISBenefitValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<CreateHRISBenefitValue> {
        protected _Deserializer() {
            super(CreateHRISBenefitValue.class);
        }

        public CreateHRISBenefitValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return CreateHRISBenefitValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<CreateHRISBenefitValue> {
        protected _Serializer() {
            super(CreateHRISBenefitValue.class);
        }

        public void serialize(CreateHRISBenefitValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

